/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.export;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.esa.smos.gui.export.GeometryTracker;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GeometryTrackerTest {
    private GeometryTracker tracker;

    @Before
    public void setUp() {
        this.tracker = new GeometryTracker();
    }

    @Test
    public void testGetGeometry_nothingAdded() {
        Rectangle2D area = this.tracker.getArea();
        Assert.assertNotNull((Object)area);
        Assert.assertTrue((boolean)area.isEmpty());
    }

    @Test
    public void testGetGeometry_addOnePoint() {
        this.tracker.add(new Point2D.Double(20.0, 10.0));
        Rectangle2D area = this.tracker.getArea();
        Assert.assertNotNull((Object)area);
        Assert.assertTrue((boolean)area.isEmpty());
    }

    @Test
    public void testGetGeometry_addTwoPoints() {
        this.tracker.add(new Point2D.Double(20.0, 10.0));
        this.tracker.add(new Point2D.Double(30.0, 5.0));
        Rectangle2D area = this.tracker.getArea();
        Assert.assertNotNull((Object)area);
        Assert.assertFalse((boolean)area.isEmpty());
        Assert.assertEquals((double)20.0, (double)area.getMinX(), (double)1.0E-8);
        Assert.assertEquals((double)30.0, (double)area.getMaxX(), (double)1.0E-8);
        Assert.assertEquals((double)5.0, (double)area.getMinY(), (double)1.0E-8);
        Assert.assertEquals((double)10.0, (double)area.getMaxY(), (double)1.0E-8);
    }

    @Test
    public void testGetGeometry_addThreePoints() {
        this.tracker.add(new Point2D.Double(20.0, 10.0));
        this.tracker.add(new Point2D.Double(30.0, 5.0));
        this.tracker.add(new Point2D.Double(40.0, 0.0));
        Rectangle2D area = this.tracker.getArea();
        Assert.assertNotNull((Object)area);
        Assert.assertFalse((boolean)area.isEmpty());
        Assert.assertEquals((double)20.0, (double)area.getMinX(), (double)1.0E-8);
        Assert.assertEquals((double)40.0, (double)area.getMaxX(), (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)area.getMinY(), (double)1.0E-8);
        Assert.assertEquals((double)10.0, (double)area.getMaxY(), (double)1.0E-8);
    }

    @Test
    public void testHasValidArea_nothingAdded() {
        Assert.assertFalse((boolean)this.tracker.hasValidArea());
    }

    @Test
    public void testHasValidArea_onePointAdded() {
        this.tracker.add(new Point2D.Double(25.0, -4.0));
        Assert.assertFalse((boolean)this.tracker.hasValidArea());
    }

    @Test
    public void testHasValidArea_twoPointsAdded() {
        this.tracker.add(new Point2D.Double(25.0, -4.0));
        this.tracker.add(new Point2D.Double(26.0, -7.0));
        Assert.assertTrue((boolean)this.tracker.hasValidArea());
    }

    @Test
    public void testHasValidArea_threePointsAdded() {
        this.tracker.add(new Point2D.Double(25.0, -4.0));
        this.tracker.add(new Point2D.Double(26.0, -7.0));
        this.tracker.add(new Point2D.Double(27.0, -9.0));
        Assert.assertTrue((boolean)this.tracker.hasValidArea());
    }
}

