/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.export;

import java.util.Date;
import org.esa.smos.gui.export.FileNamePatcher;
import org.junit.Assert;
import org.junit.Test;

public class FileNamePatcherTest {
    @Test
    public void testPatchDates() {
        FileNamePatcher patcher = new FileNamePatcher("SM_TEST_MIR_SCLD1C_20070223T061024_20070223T070437_141_000_0");
        patcher.setStartDate(new Date(1000000L));
        patcher.setStopDate(new Date(1010000L));
        Assert.assertEquals((Object)"SM_TEST_MIR_SCLD1C_19700101T001640_19700101T001650_141_000_0.HDR", (Object)patcher.getHdrFileName());
        Assert.assertEquals((Object)"SM_TEST_MIR_SCLD1C_19700101T001640_19700101T001650_141_000_0.DBL", (Object)patcher.getDblFileName());
        Assert.assertEquals((Object)"SM_TEST_MIR_SCLD1C_19700101T001640_19700101T001650_141_000_0", (Object)patcher.getFileNameWithoutExtension());
    }

    @Test
    public void testPatchNoDates() {
        FileNamePatcher patcher = new FileNamePatcher("SM_TEST_MIR_SCLD1C_20070223T061024_20070223T070437_141_000_0");
        Assert.assertEquals((Object)"SM_TEST_MIR_SCLD1C_20070223T061024_20070223T070437_141_000_0.HDR", (Object)patcher.getHdrFileName());
        Assert.assertEquals((Object)"SM_TEST_MIR_SCLD1C_20070223T061024_20070223T070437_141_000_0.DBL", (Object)patcher.getDblFileName());
        Assert.assertEquals((Object)"SM_TEST_MIR_SCLD1C_20070223T061024_20070223T070437_141_000_0", (Object)patcher.getFileNameWithoutExtension());
    }

    @Test
    public void testPatchFileCounter_noPatching() {
        FileNamePatcher patcher = new FileNamePatcher("SM_REPR_MIR_SCLF1C_20110904T022557_20110904T031917_504_001_5");
        patcher.setFileCounter(0);
        Assert.assertEquals((Object)"SM_REPR_MIR_SCLF1C_20110904T022557_20110904T031917_504_001_5.HDR", (Object)patcher.getHdrFileName());
        Assert.assertEquals((Object)"SM_REPR_MIR_SCLF1C_20110904T022557_20110904T031917_504_001_5.DBL", (Object)patcher.getDblFileName());
        Assert.assertEquals((Object)"SM_REPR_MIR_SCLF1C_20110904T022557_20110904T031917_504_001_5", (Object)patcher.getFileNameWithoutExtension());
    }

    @Test
    public void testPatchFileCounter_oneDigit() {
        FileNamePatcher patcher = new FileNamePatcher("SM_REPR_MIR_SCLF1C_20110904T022557_20110904T031917_504_001_5");
        patcher.setFileCounter(9);
        Assert.assertEquals((Object)"SM_REPR_MIR_SCLF1C_20110904T022557_20110904T031917_504_009_5.HDR", (Object)patcher.getHdrFileName());
        Assert.assertEquals((Object)"SM_REPR_MIR_SCLF1C_20110904T022557_20110904T031917_504_009_5.DBL", (Object)patcher.getDblFileName());
        Assert.assertEquals((Object)"SM_REPR_MIR_SCLF1C_20110904T022557_20110904T031917_504_009_5", (Object)patcher.getFileNameWithoutExtension());
    }

    @Test
    public void testPatchFileCounter_threeDigits() {
        FileNamePatcher patcher = new FileNamePatcher("SM_REPR_MIR_SCLF1C_20110904T022557_20110904T031917_504_001_5");
        patcher.setFileCounter(198);
        Assert.assertEquals((Object)"SM_REPR_MIR_SCLF1C_20110904T022557_20110904T031917_504_198_5.HDR", (Object)patcher.getHdrFileName());
        Assert.assertEquals((Object)"SM_REPR_MIR_SCLF1C_20110904T022557_20110904T031917_504_198_5.DBL", (Object)patcher.getDblFileName());
        Assert.assertEquals((Object)"SM_REPR_MIR_SCLF1C_20110904T022557_20110904T031917_504_198_5", (Object)patcher.getFileNameWithoutExtension());
    }

    @Test
    public void testPatchFileCounter_fiveDigits() {
        FileNamePatcher patcher = new FileNamePatcher("SM_REPR_MIR_SCLF1C_20110904T022557_20110904T031917_504_001_5");
        patcher.setFileCounter(12345);
        Assert.assertEquals((Object)"SM_REPR_MIR_SCLF1C_20110904T022557_20110904T031917_504_345_5.HDR", (Object)patcher.getHdrFileName());
        Assert.assertEquals((Object)"SM_REPR_MIR_SCLF1C_20110904T022557_20110904T031917_504_345_5.DBL", (Object)patcher.getDblFileName());
        Assert.assertEquals((Object)"SM_REPR_MIR_SCLF1C_20110904T022557_20110904T031917_504_345_5", (Object)patcher.getFileNameWithoutExtension());
    }
}

