/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.export;

import com.bc.ceres.binio.CollectionData;
import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.CompoundMember;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.DataFormat;
import com.bc.ceres.binio.IOHandler;
import com.bc.ceres.binio.SequenceData;
import com.bc.ceres.binio.SimpleType;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.TypeBuilder;
import com.bc.ceres.binio.internal.CompoundInstance;
import com.bc.ceres.binio.internal.InstanceFactory;
import com.bc.ceres.binio.util.ByteArrayIOHandler;
import com.bc.ceres.binio.util.DataPrinter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteOrder;
import java.util.Date;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.esa.smos.dataio.smos.GridPointList;
import org.esa.smos.dataio.smos.ProductFile;
import org.esa.smos.dataio.smos.SmosFile;
import org.esa.smos.dataio.smos.SmosProductReader;
import org.esa.smos.gui.export.EEExportGridPointHandler;
import org.esa.smos.gui.export.GridPointFilter;
import org.junit.Assert;
import org.junit.Test;

public class EEExportGridPointHandlerTest {
    private static final String SCENARIO_27_DBL_NAME = "scenario27/SM_TEST_MIR_SCSD1C_20070223T142110_20070223T142111_320_001_0/SM_TEST_MIR_SCSD1C_20070223T142110_20070223T142111_320_001_0.DBL";

    @Test
    public void handleGridPointsForScenario27() throws URISyntaxException, IOException {
        ProductFile productFile = SmosProductReader.createProductFile((File)EEExportGridPointHandlerTest.getResourceAsFile(SCENARIO_27_DBL_NAME));
        Assert.assertTrue((boolean)(productFile instanceof SmosFile));
        SmosFile sourceFile = (SmosFile)productFile;
        GridPointList sourceGridPointList = sourceFile.getGridPointList();
        Assert.assertEquals((long)5533L, (long)sourceGridPointList.getElementCount());
        DataContext targetContext = sourceFile.getDataFormat().createContext((IOHandler)new ByteArrayIOHandler());
        EEExportGridPointHandler handler = new EEExportGridPointHandler(targetContext, new GridPointFilter(){

            public boolean accept(int id, CompoundData gridPointData) throws IOException {
                return id == 0 || id == 7;
            }
        });
        for (int i = 0; i < sourceGridPointList.getElementCount(); ++i) {
            CompoundData gridPointData = sourceGridPointList.getCompound(i);
            handler.handleGridPoint(i, gridPointData);
        }
        CompoundData targetData = targetContext.createData();
        targetContext.dispose();
        DataPrinter dataPrinter = new DataPrinter();
        dataPrinter.print((CollectionData)targetData);
        SequenceData targetSnapshotList = targetData.getSequence("Swath_Snapshot_List");
        Assert.assertEquals((long)2L, (long)targetSnapshotList.getElementCount());
        Assert.assertEquals((long)60046L, (long)targetSnapshotList.getCompound(0).getInt("Snapshot_ID"));
        Assert.assertEquals((long)60047L, (long)targetSnapshotList.getCompound(1).getInt("Snapshot_ID"));
        SequenceData targetGridPointList = targetData.getSequence("Grid_Point_List");
        Assert.assertEquals((long)2L, (long)targetGridPointList.getElementCount());
        EEExportGridPointHandlerTest.assertGridPointData(targetGridPointList.getCompound(0), 233545, 70.169426f, 173.99301f);
        EEExportGridPointHandlerTest.assertGridPointData(targetGridPointList.getCompound(1), 235084, 62.994823f, 179.01186f);
    }

    @Test
    public void testGetL2TimeStamp() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(baos);
        ios.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        ios.writeInt(1250);
        ios.writeInt(890);
        ios.writeInt(100);
        ios.close();
        CompoundType type = TypeBuilder.COMPOUND((String)"dontcare", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"Days", (Type)SimpleType.INT), TypeBuilder.MEMBER((String)"Seconds", (Type)SimpleType.UINT), TypeBuilder.MEMBER((String)"Microseconds", (Type)SimpleType.UINT)});
        byte[] byteData = baos.toByteArray();
        DataContext context = new DataFormat(type, ByteOrder.LITTLE_ENDIAN).createContext((IOHandler)new ByteArrayIOHandler(byteData));
        CompoundInstance compoundData = InstanceFactory.createCompound((DataContext)context, null, (CompoundType)type, (long)0L, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        Date l2MjdTimeStamp = EEExportGridPointHandler.getL2MjdTimeStamp((CompoundData)compoundData);
        Assert.assertEquals((Object)new Date(1054685690000L), (Object)l2MjdTimeStamp);
        baos = new ByteArrayOutputStream();
        ios = new MemoryCacheImageOutputStream(baos);
        ios.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        ios.writeInt(1252);
        ios.writeInt(890);
        ios.writeInt(100);
        ios.close();
        byteData = baos.toByteArray();
        context = new DataFormat(type, ByteOrder.LITTLE_ENDIAN).createContext((IOHandler)new ByteArrayIOHandler(byteData));
        compoundData = InstanceFactory.createCompound((DataContext)context, null, (CompoundType)type, (long)0L, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        l2MjdTimeStamp = EEExportGridPointHandler.getL2MjdTimeStamp((CompoundData)compoundData);
        Assert.assertEquals((Object)new Date(1054858490000L), (Object)l2MjdTimeStamp);
    }

    @Test
    public void testGetL2TimeStamp_notExistingMember() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(baos);
        ios.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        ios.writeFloat(26.99f);
        ios.close();
        CompoundType type = TypeBuilder.COMPOUND((String)"dontcare", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"schnickschnack", (Type)SimpleType.FLOAT)});
        byte[] byteData = baos.toByteArray();
        DataContext context = new DataFormat(type, ByteOrder.LITTLE_ENDIAN).createContext((IOHandler)new ByteArrayIOHandler(byteData));
        CompoundInstance compoundData = InstanceFactory.createCompound((DataContext)context, null, (CompoundType)type, (long)0L, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        Date l2MjdTimeStamp = EEExportGridPointHandler.getL2MjdTimeStamp((CompoundData)compoundData);
        Assert.assertNull((Object)l2MjdTimeStamp);
    }

    @Test
    public void testGetL2TimeStamp_zeroValues() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(baos);
        ios.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        ios.writeInt(0);
        ios.writeInt(0);
        ios.writeInt(0);
        ios.close();
        CompoundType type = TypeBuilder.COMPOUND((String)"dontcare", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"Mean_Acq_Time", (Type)TypeBuilder.COMPOUND((String)"UTC_Type", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"Days", (Type)SimpleType.INT), TypeBuilder.MEMBER((String)"Seconds", (Type)SimpleType.UINT), TypeBuilder.MEMBER((String)"Microseconds", (Type)SimpleType.UINT)}))});
        byte[] byteData = baos.toByteArray();
        DataContext context = new DataFormat(type, ByteOrder.LITTLE_ENDIAN).createContext((IOHandler)new ByteArrayIOHandler(byteData));
        CompoundInstance compoundData = InstanceFactory.createCompound((DataContext)context, null, (CompoundType)type, (long)0L, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        Date l2MjdTimeStamp = EEExportGridPointHandler.getL2MjdTimeStamp((CompoundData)compoundData);
        Assert.assertNull((Object)l2MjdTimeStamp);
    }

    private static void assertGridPointData(CompoundData gridPointData, int id, float ... bt) throws IOException {
        Assert.assertEquals((long)id, (long)gridPointData.getInt("Grid_Point_ID"));
        SequenceData btDataSequence = gridPointData.getSequence("BT_Data");
        Assert.assertEquals((long)bt.length, (long)btDataSequence.getElementCount());
        for (int i = 0; i < bt.length; ++i) {
            Assert.assertEquals((float)bt[i], (float)btDataSequence.getCompound(i).getFloat("BT_Value"), (float)0.0f);
        }
    }

    private static File getResourceAsFile(String name) throws URISyntaxException {
        URL url = EEExportGridPointHandlerTest.class.getResource(name);
        URI uri = url.toURI();
        return new File(uri);
    }
}

