/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.esa.smos.gui.TableModelExporter;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TableModelExporterTest {
    private ByteArrayOutputStream stream;
    private TableColumnModelExt columnModel;

    @Before
    public void setUp() {
        this.stream = new ByteArrayOutputStream();
        this.columnModel = this.createColumnModel();
    }

    @Test
    public void testSimpleModel() {
        TableModel tableModel = this.createTableModel();
        TableModelExporter exporter = new TableModelExporter(tableModel, this.columnModel);
        exporter.setSeparator('\t');
        exporter.export((OutputStream)this.stream);
        String actual = this.stream.toString();
        this.assertTableModel(actual);
    }

    @Test
    public void testSimpleModelWithDifferentColumnVisibility() {
        TableModel tableModel = this.createTableModel();
        TableModelExporter exporter = new TableModelExporter(tableModel, this.createColumnModelWithoutTiffy());
        exporter.setSeparator('\t');
        exporter.export((OutputStream)this.stream);
        String actual = this.stream.toString();
        Assert.assertTrue((boolean)actual.contains("Bibo\tSamson"));
        Assert.assertTrue((boolean)actual.contains("12\t45.456"));
        Assert.assertTrue((boolean)actual.contains("11\t129.5678"));
        Assert.assertTrue((boolean)actual.contains("2\t0.1"));
    }

    @Test
    public void testSimpleModelNoColumnVisibility() {
        TableModel tableModel = this.createTableModel();
        TableModelExporter exporter = new TableModelExporter(tableModel, this.createEmptyColumnModel());
        exporter.setSeparator('\t');
        exporter.export((OutputStream)this.stream);
        Assert.assertTrue((boolean)this.stream.toString().trim().isEmpty());
    }

    private void assertTableModel(String actual) {
        Assert.assertTrue((boolean)actual.contains("Bibo\tTiffy\tSamson"));
        Assert.assertTrue((boolean)actual.contains("12\tCat\t45.456"));
        Assert.assertTrue((boolean)actual.contains("11\tMouse\t129.5678"));
        Assert.assertTrue((boolean)actual.contains("2\tDog\t0.1"));
    }

    private TableModel createTableModel() {
        Object[] columnNames = new String[]{"Bibo", "Tiffy", "Samson"};
        Object[][] tableData = new Object[][]{{12, "Cat", 45.456}, {11, "Mouse", 129.5678}, {2, "Dog", 0.1}};
        DefaultTableModel tableModel = new DefaultTableModel();
        tableModel.setDataVector(tableData, columnNames);
        return tableModel;
    }

    private TableColumnModelExt createColumnModel() {
        TableColumnModelExt columnModel = (TableColumnModelExt)Mockito.mock(TableColumnModelExt.class);
        Mockito.when((Object)columnModel.getColumnCount(false)).thenReturn((Object)3);
        TableColumnExt biboMock = (TableColumnExt)Mockito.mock(TableColumnExt.class);
        Mockito.when((Object)biboMock.getHeaderValue()).thenReturn((Object)"Bibo");
        Mockito.when((Object)biboMock.getModelIndex()).thenReturn((Object)0);
        TableColumnExt tiffyMock = (TableColumnExt)Mockito.mock(TableColumnExt.class);
        Mockito.when((Object)tiffyMock.getHeaderValue()).thenReturn((Object)"Tiffy");
        Mockito.when((Object)tiffyMock.getModelIndex()).thenReturn((Object)1);
        TableColumnExt samsonMock = (TableColumnExt)Mockito.mock(TableColumnExt.class);
        Mockito.when((Object)samsonMock.getHeaderValue()).thenReturn((Object)"Samson");
        Mockito.when((Object)samsonMock.getModelIndex()).thenReturn((Object)2);
        Mockito.when((Object)columnModel.getColumn(0)).thenReturn((Object)biboMock);
        Mockito.when((Object)columnModel.getColumn(1)).thenReturn((Object)tiffyMock);
        Mockito.when((Object)columnModel.getColumn(2)).thenReturn((Object)samsonMock);
        return columnModel;
    }

    private TableColumnModelExt createColumnModelWithoutTiffy() {
        TableColumnModelExt columnModel = (TableColumnModelExt)Mockito.mock(TableColumnModelExt.class);
        Mockito.when((Object)columnModel.getColumnCount(false)).thenReturn((Object)2);
        TableColumnExt biboMock = (TableColumnExt)Mockito.mock(TableColumnExt.class);
        Mockito.when((Object)biboMock.getHeaderValue()).thenReturn((Object)"Bibo");
        Mockito.when((Object)biboMock.getModelIndex()).thenReturn((Object)0);
        TableColumnExt samsonMock = (TableColumnExt)Mockito.mock(TableColumnExt.class);
        Mockito.when((Object)samsonMock.getHeaderValue()).thenReturn((Object)"Samson");
        Mockito.when((Object)samsonMock.getModelIndex()).thenReturn((Object)2);
        Mockito.when((Object)columnModel.getColumn(0)).thenReturn((Object)biboMock);
        Mockito.when((Object)columnModel.getColumn(1)).thenReturn((Object)samsonMock);
        return columnModel;
    }

    private TableColumnModelExt createEmptyColumnModel() {
        TableColumnModelExt columnModel = (TableColumnModelExt)Mockito.mock(TableColumnModelExt.class);
        Mockito.when((Object)columnModel.getColumnCount(false)).thenReturn((Object)0);
        return columnModel;
    }
}

