/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.smos.gui;

import java.awt.GraphicsEnvironment;
import java.io.File;
import org.esa.beam.framework.gpf.ui.DefaultAppContext;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.smos.gui.GuiHelper;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class GuiHelperTest {
    private final boolean isGuiAvailable = !GraphicsEnvironment.isHeadless();

    @Test
    public void testGetDefaultSourceDirectory_fromUserHome() {
        Assume.assumeTrue((boolean)this.isGuiAvailable);
        DefaultAppContext appContext = new DefaultAppContext("bla");
        String propertyString = appContext.getPreferences().getPropertyString("org.esa.beam.smos.export.sourceDir");
        Assert.assertEquals((Object)"", (Object)propertyString);
        String expected = System.getProperty("user.home", ".");
        Assert.assertEquals((Object)expected, (Object)GuiHelper.getDefaultSourceDirectory((AppContext)appContext).getPath());
    }

    @Test
    public void testGetDefaultSourceDirectory_fromPreferences() {
        Assume.assumeTrue((boolean)this.isGuiAvailable);
        String expected = File.separator + "another" + File.separator + "dir";
        DefaultAppContext appContext = new DefaultAppContext("bla");
        appContext.getPreferences().setPropertyString("org.esa.beam.smos.export.sourceDir", expected);
        Assert.assertEquals((Object)expected, (Object)GuiHelper.getDefaultSourceDirectory((AppContext)appContext).getPath());
    }

    @Test
    public void testSetDefaultSourceDirectory_fromPreferences() {
        Assume.assumeTrue((boolean)this.isGuiAvailable);
        DefaultAppContext appContext = new DefaultAppContext("bla");
        File file = new File("/default/source/directory");
        GuiHelper.setDefaultSourceDirectory((File)file, (AppContext)appContext);
        String propertyString = appContext.getPreferences().getPropertyString("org.esa.beam.smos.export.sourceDir");
        Assert.assertEquals((Object)file.getPath(), (Object)propertyString);
    }

    @Test
    public void testGetDefaultTargetDirectory_fromUserHome() {
        Assume.assumeTrue((boolean)this.isGuiAvailable);
        DefaultAppContext appContext = new DefaultAppContext("bla");
        String propertyString = appContext.getPreferences().getPropertyString("org.esa.beam.smos.export.targetDir");
        Assert.assertEquals((Object)"", (Object)propertyString);
        String expected = System.getProperty("user.home", ".");
        Assert.assertEquals((Object)expected, (Object)GuiHelper.getDefaultTargetDirectory((AppContext)appContext).getPath());
    }

    @Test
    public void testGetDefaultTargetDirectory_fromPreferences() {
        Assume.assumeTrue((boolean)this.isGuiAvailable);
        String expected = File.separator + "target" + File.separator + "directory";
        DefaultAppContext appContext = new DefaultAppContext("bla");
        appContext.getPreferences().setPropertyString("org.esa.beam.smos.export.targetDir", expected);
        Assert.assertEquals((Object)expected, (Object)GuiHelper.getDefaultTargetDirectory((AppContext)appContext).getPath());
    }

    @Test
    public void testSetDefaultTargetDirectory() {
        Assume.assumeTrue((boolean)this.isGuiAvailable);
        DefaultAppContext appContext = new DefaultAppContext("schwafel");
        File file = new File("/default/target/directory");
        GuiHelper.setDefaultTargetDirectory((File)file, (AppContext)appContext);
        String propertyString = appContext.getPreferences().getPropertyString("org.esa.beam.smos.export.targetDir");
        Assert.assertEquals((Object)file.getPath(), (Object)propertyString);
    }
}

