/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.ee2netcdf.ui;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKTWriter;
import java.awt.Component;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.esa.smos.ee2netcdf.ExportParameter;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.ui.AppContext;

class NetcdfExportSwingWorker
extends ProgressMonitorSwingWorker<List<Exception>, File> {
    private final AppContext appContext;
    private final ExportParameter exportParameter;

    NetcdfExportSwingWorker(AppContext appContext, ExportParameter exportParameter) {
        super((Component)appContext.getApplicationWindow(), "Exporting to NetCDF");
        this.appContext = appContext;
        this.exportParameter = exportParameter;
    }

    protected List<Exception> doInBackground(ProgressMonitor pm) throws Exception {
        pm.beginTask("Converting product(s)", -1);
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        HashMap<String, Object> parameterMap = NetcdfExportSwingWorker.createParameterMap(this.exportParameter);
        try {
            if (this.exportParameter.isUseSelectedProduct()) {
                Product selectedProduct = this.appContext.getSelectedProduct();
                GPF.createProduct((String)"SmosNetcdfExport", parameterMap, (Product[])new Product[]{selectedProduct});
            } else {
                GPF.createProduct((String)"SmosNetcdfExport", parameterMap);
            }
        }
        catch (Exception e) {
            exceptions.add(e);
        }
        pm.done();
        return exceptions;
    }

    protected void done() {
        try {
            List problemList = (List)this.get();
            if (!problemList.isEmpty()) {
                StringBuilder message = new StringBuilder();
                message.append("The following problem(s) have occurred:\n");
                for (Exception problem : problemList) {
                    problem.printStackTrace();
                    message.append("  ");
                    message.append(problem.getMessage());
                    message.append("\n");
                }
                this.appContext.handleError(message.toString(), null);
            }
        }
        catch (InterruptedException e) {
            this.appContext.handleError(MessageFormat.format("An error occurred: {0}", e.getMessage()), (Throwable)e);
        }
        catch (ExecutionException e) {
            this.appContext.handleError(MessageFormat.format("An error occurred: {0}", e.getCause().getMessage()), e.getCause());
        }
    }

    static HashMap<String, Object> createParameterMap(ExportParameter exportParameter) {
        String[] variableNames;
        String institution;
        int roiType;
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        File targetDirectory = exportParameter.getTargetDirectory();
        if (targetDirectory != null) {
            parameterMap.put("targetDirectory", targetDirectory);
        }
        File sourceDirectory = exportParameter.getSourceDirectory();
        if (!exportParameter.isUseSelectedProduct() && sourceDirectory != null) {
            String sourcePath = NetcdfExportSwingWorker.createSourcePathWildcards(sourceDirectory);
            parameterMap.put("sourceProductPaths", sourcePath);
        }
        if ((roiType = exportParameter.getRoiType()) == 2) {
            parameterMap.put("geometry", exportParameter.boundingBoxToWKT());
        } else if (roiType == 1) {
            NetcdfExportSwingWorker.addSelectedProductGeometry(exportParameter.getGeometry(), parameterMap);
        } else if (roiType == 0) {
            parameterMap.remove("geometry");
        }
        if (exportParameter.isOverwriteTarget()) {
            parameterMap.put("overwriteTarget", "true");
        } else {
            parameterMap.put("overwriteTarget", "false");
        }
        String contact = exportParameter.getContact();
        if (contact != null) {
            parameterMap.put("contact", contact);
        }
        if ((institution = exportParameter.getInstitution()) != null) {
            parameterMap.put("institution", institution);
        }
        if ((variableNames = exportParameter.getVariableNames()) != null && variableNames.length != 0) {
            parameterMap.put("variableNames", StringUtils.arrayToCsv((Object)exportParameter.getVariableNames()));
        }
        parameterMap.put("compressionLevel", exportParameter.getCompressionLevel());
        return parameterMap;
    }

    static String createSourcePathWildcards(File sourceDirectory) {
        StringBuilder sourcePath = new StringBuilder();
        String absolutePath = sourceDirectory.getAbsolutePath();
        sourcePath.append(absolutePath);
        sourcePath.append(File.separator);
        sourcePath.append("*.zip,");
        sourcePath.append(absolutePath);
        sourcePath.append(File.separator);
        sourcePath.append("*.dbl,");
        sourcePath.append(absolutePath);
        sourcePath.append(File.separator);
        sourcePath.append("*");
        sourcePath.append(File.separator);
        sourcePath.append("*.dbl");
        return sourcePath.toString();
    }

    static void addSelectedProductGeometry(Geometry geometry, HashMap<String, Object> parameterMap) {
        if (geometry instanceof Polygon) {
            WKTWriter wktWriter = new WKTWriter();
            String wkt = wktWriter.write(geometry);
            parameterMap.put("geometry", wkt);
        }
    }
}

