/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.ee2netcdf.ui;

import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertyDescriptorFactory;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.converters.ArrayConverter;
import com.bc.ceres.binding.converters.StringConverter;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.Binding;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.PropertyPane;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import org.esa.smos.ee2netcdf.ExportParameter;
import org.esa.smos.ee2netcdf.NetcdfExportOp;
import org.esa.smos.ee2netcdf.ui.DialogHelper;
import org.esa.smos.ee2netcdf.ui.NetcdfExportSwingWorker;
import org.esa.smos.gui.ChooserFactory;
import org.esa.smos.gui.DefaultChooserFactory;
import org.esa.smos.gui.DirectoryChooserFactory;
import org.esa.smos.gui.ProductChangeAwareDialog;
import org.esa.smos.gui.swing.GuiHelper;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.gpf.annotations.ParameterDescriptorFactory;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.SelectionSupport;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.RegionBoundsInputUI;

class NetcdfExportDialog
extends ProductChangeAwareDialog {
    private final AppContext appContext;
    private final ExportParameter exportParameter;
    private final PropertySet propertySet;
    private final BindingContext bindingContext;

    NetcdfExportDialog(AppContext appContext, String helpID) {
        super(appContext.getApplicationWindow(), "Export SMOS Earth Explorer Files to NetCDF", 145, helpID);
        this.appContext = appContext;
        this.exportParameter = new ExportParameter();
        this.propertySet = PropertyContainer.createObjectBacked((Object)this.exportParameter, (PropertyDescriptorFactory)new ParameterDescriptorFactory());
        this.propertySet.setDefaultValues();
        this.bindingContext = new BindingContext(this.propertySet);
        JPanel ioPanel = GuiHelper.createPanelWithBoxLayout();
        ioPanel.add(this.createSourceProductsSelector());
        ioPanel.add(this.createTargetDirSelector());
        ioPanel.add(this.createRoiSelector());
        JTabbedPane form = new JTabbedPane();
        form.add("I/O Parameters", ioPanel);
        if (this.propertySet.getProperties().length > 0) {
            this.propertySet.getDescriptor("openFileDialog").setAttribute("visible", (Object)false);
            this.propertySet.getDescriptor("useSelectedProduct").setAttribute("visible", (Object)false);
            this.propertySet.getDescriptor("sourceDirectory").setAttribute("visible", (Object)false);
            this.propertySet.getDescriptor("targetDirectory").setAttribute("visible", (Object)false);
            this.propertySet.getDescriptor("roiType").setAttribute("visible", (Object)false);
            this.propertySet.getDescriptor("geometry").setAttribute("visible", (Object)false);
            this.propertySet.getDescriptor("northBound").setAttribute("visible", (Object)false);
            this.propertySet.getDescriptor("southBound").setAttribute("visible", (Object)false);
            this.propertySet.getDescriptor("eastBound").setAttribute("visible", (Object)false);
            this.propertySet.getDescriptor("westBound").setAttribute("visible", (Object)false);
            ArrayConverter arrayConverter = new ArrayConverter(String[].class, (Converter)new StringConverter());
            this.propertySet.getDescriptor("variables").setConverter((Converter)arrayConverter);
            PropertyPane parametersPane = new PropertyPane(this.bindingContext);
            JPanel parametersPanel = parametersPane.createPanel();
            parametersPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
            form.add("Processing Parameters", new JScrollPane(parametersPanel));
        }
        this.setContent(form);
        try {
            this.init(this.propertySet);
        }
        catch (ValidationException e) {
            throw new IllegalStateException(e.getMessage());
        }
        ProductManager productManager = appContext.getProductManager();
        productManager.addListener((ProductManager.Listener)new ProductChangeAwareDialog.ProductManagerListener((ProductChangeAwareDialog)this));
        SelectionSupport selectionSupport = SnapApp.getDefault().getSelectionSupport(Product.class);
        selectionSupport.addHandler((SelectionSupport.Handler)this);
    }

    protected final void onOK() {
        try {
            List<Path> existingFiles;
            List<Path> targetFiles = this.exportParameter.isUseSelectedProduct() ? NetcdfExportDialog.getTargetFiles(this.appContext.getSelectedProduct().getFileLocation().toPath(), this.exportParameter.getTargetDirectory().toPath()) : NetcdfExportDialog.getTargetFiles(this.exportParameter.getSourceDirectory().toPath(), "*", this.exportParameter.getTargetDirectory().toPath());
            if (!this.exportParameter.isOverwriteTarget() && !(existingFiles = NetcdfExportDialog.getExistingPaths(targetFiles)).isEmpty()) {
                String files = NetcdfExportDialog.listToString(existingFiles);
                String message = MessageFormat.format("The selected target file(s) already exists.\n\nDo you want to overwrite the target file(s)?\n\n{0}", files);
                int answer = JOptionPane.showConfirmDialog(this.getJDialog(), message, this.getTitle(), 0);
                if (answer == 1) {
                    return;
                }
                this.exportParameter.setOverwriteTarget(true);
            }
        }
        catch (IOException e) {
            this.showErrorDialog(e.getMessage());
            return;
        }
        NetcdfExportSwingWorker worker = new NetcdfExportSwingWorker(this.appContext, this.exportParameter);
        GuiHelper.setDefaultSourceDirectory((File)this.exportParameter.getSourceDirectory(), (AppContext)this.appContext);
        GuiHelper.setDefaultTargetDirectory((File)this.exportParameter.getTargetDirectory(), (AppContext)this.appContext);
        worker.execute();
    }

    private JComponent createSourceProductsSelector() {
        PropertyDescriptor sourceDirectoryDescriptor = this.propertySet.getDescriptor("sourceDirectory");
        JComponent fileEditor = GuiHelper.createFileEditorComponent((PropertyDescriptor)sourceDirectoryDescriptor, (ChooserFactory)new DefaultChooserFactory(), (BindingContext)this.bindingContext);
        TableLayout layout = GuiHelper.createWeightedTableLayout((int)1);
        layout.setCellPadding(2, 0, new Insets(0, 24, 3, 3));
        JPanel panel = new JPanel((LayoutManager)layout);
        panel.setBorder(BorderFactory.createTitledBorder("Source Products"));
        GuiHelper.addSourceProductsButtons((JPanel)panel, (boolean)DialogHelper.isProductSelectionFeasible(this.appContext), (BindingContext)this.bindingContext);
        panel.add(fileEditor);
        return panel;
    }

    private JComponent createTargetDirSelector() {
        JLabel label = new JLabel();
        label.setText("Save files to directory:");
        PropertyDescriptor targetDirectoryDescriptor = this.propertySet.getDescriptor("targetDirectory");
        JComponent fileEditor = GuiHelper.createFileEditorComponent((PropertyDescriptor)targetDirectoryDescriptor, (ChooserFactory)new DirectoryChooserFactory(), (BindingContext)this.bindingContext, (boolean)false);
        JPanel panel = new JPanel((LayoutManager)GuiHelper.createWeightedTableLayout((int)1));
        panel.setBorder(BorderFactory.createTitledBorder("Target Directory"));
        panel.add(label);
        panel.add(fileEditor);
        return panel;
    }

    private JComponent createRoiSelector() {
        JRadioButton allButton = new JRadioButton("All");
        allButton.setToolTipText("Check this button to select the whole globe");
        JRadioButton useGeometryButton = new JRadioButton("Polygon");
        useGeometryButton.setToolTipText("Check this button to specify a region-of-interest in form a polygon geometry.");
        PropertyDescriptor geometryDescriptor = this.propertySet.getDescriptor("geometry");
        JRadioButton useBoundingBoxButton = new JRadioButton("Bounding box");
        useBoundingBoxButton.setToolTipText("Check this button to specify a region-of-interest in form a bounding box.");
        HashMap<JRadioButton, Integer> buttonGroupValueSet = new HashMap<JRadioButton, Integer>();
        buttonGroupValueSet.put(allButton, 0);
        buttonGroupValueSet.put(useGeometryButton, 1);
        buttonGroupValueSet.put(useBoundingBoxButton, 2);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(allButton);
        buttonGroup.add(useGeometryButton);
        buttonGroup.add(useBoundingBoxButton);
        this.bindingContext.bind("roiType", buttonGroup, buttonGroupValueSet);
        TableLayout layout = GuiHelper.createWeightedTableLayout((int)1);
        layout.setCellPadding(2, 0, new Insets(0, 24, 3, 3));
        layout.setCellPadding(4, 0, new Insets(0, 24, 3, 3));
        JPanel panel = new JPanel((LayoutManager)layout);
        panel.setBorder(BorderFactory.createTitledBorder("Region of Interest"));
        JTextArea geometryTextArea = new JTextArea(5, 20);
        JScrollPane geometryScrollPane = new JScrollPane(geometryTextArea);
        geometryTextArea.setToolTipText(geometryDescriptor.getDescription());
        this.bindingContext.bind("geometry", (JTextComponent)geometryTextArea);
        this.bindingContext.bindEnabledState("geometry", true, "roiType", (Object)1);
        panel.add(allButton);
        panel.add(useGeometryButton);
        panel.add(geometryScrollPane);
        panel.add(useBoundingBoxButton);
        RegionBoundsInputUI regionBoundsInputUI = new RegionBoundsInputUI(this.bindingContext);
        this.bindingContext.addPropertyChangeListener("roiType", changeEvent -> {
            int roiType = (Integer)changeEvent.getNewValue();
            if (roiType == 2) {
                regionBoundsInputUI.setEnabled(true);
            } else {
                regionBoundsInputUI.setEnabled(false);
            }
        });
        regionBoundsInputUI.setEnabled(false);
        panel.add(regionBoundsInputUI.getUI());
        panel.revalidate();
        panel.repaint();
        return panel;
    }

    private void init(PropertySet propertySet) throws ValidationException {
        File defaultSourceDirectory = GuiHelper.getDefaultSourceDirectory((AppContext)this.appContext);
        propertySet.setValue("sourceDirectory", (Object)defaultSourceDirectory);
        File defaultTargetDirectory = GuiHelper.getDefaultTargetDirectory((AppContext)this.appContext);
        propertySet.setValue("targetDirectory", (Object)defaultTargetDirectory);
        this.updateSelectedProductButton();
    }

    private void updateSelectedProductButton() {
        Product selectedSmosProduct = DialogHelper.getSelectedSmosProduct(this.appContext);
        if (selectedSmosProduct == null) {
            this.setSelectedProductButtonEnabled(false);
            this.bindingContext.getBinding("useSelectedProduct").setPropertyValue((Object)false);
        } else {
            this.setSelectedProductButtonEnabled(true);
            this.bindingContext.getBinding("useSelectedProduct").setPropertyValue((Object)true);
        }
    }

    private void setSelectedProductButtonEnabled(boolean enabled) {
        JComponent[] components;
        Binding binding = this.bindingContext.getBinding("useSelectedProduct");
        for (JComponent component : components = binding.getComponents()) {
            if (!(component instanceof JRadioButton) || !((JRadioButton)component).getText().equals("Use selected SMOS product")) continue;
            component.setEnabled(enabled);
            break;
        }
    }

    static List<Path> getTargetFiles(Path sourceDir, String globPattern, Path targetDir) throws IOException {
        ArrayList<Path> targetFiles = new ArrayList<Path>();
        DirectoryStream<Path> paths = Files.newDirectoryStream(sourceDir, globPattern);
        paths.forEach(path -> {
            Path outputFile = NetcdfExportOp.getOutputFile((Path)path, (Path)targetDir);
            targetFiles.add(outputFile);
        });
        Collections.sort(targetFiles);
        return targetFiles;
    }

    static List<Path> getTargetFiles(Path filePath, Path targetDir) throws IOException {
        ArrayList<Path> targetFiles = new ArrayList<Path>();
        Path outputFile = NetcdfExportOp.getOutputFile((Path)filePath, (Path)targetDir);
        targetFiles.add(outputFile);
        return targetFiles;
    }

    static List<Path> getExistingPaths(List<Path> targetFiles) {
        return targetFiles.stream().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).collect(Collectors.toList());
    }

    static String listToString(List<Path> targetFiles) {
        StringBuilder builder = new StringBuilder();
        int fileCount = 0;
        for (Path targetFile : targetFiles) {
            builder.append(targetFile.toAbsolutePath());
            builder.append("\n");
            if (++fileCount < 10) continue;
            builder.append("...");
            break;
        }
        return builder.toString();
    }

    protected void onClose() {
        SelectionSupport selectionSupport = SnapApp.getDefault().getSelectionSupport(Product.class);
        selectionSupport.removeHandler((SelectionSupport.Handler)this);
        super.onClose();
    }

    protected void productAdded() {
        this.updateSelectedProductButton();
    }

    protected void productRemoved(Product product) {
        this.updateSelectedProductButton();
    }

    protected void geometryAdded() {
    }

    protected void geometryRemoved() {
    }

    protected void productSelectionChanged() {
        this.updateSelectedProductButton();
    }
}

