/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.aatsr.regrid;

import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.pointop.PixelOperator;
import org.esa.snap.core.gpf.pointop.ProductConfigurer;
import org.esa.snap.core.gpf.pointop.Sample;
import org.esa.snap.core.gpf.pointop.SourceSampleConfigurer;
import org.esa.snap.core.gpf.pointop.TargetSampleConfigurer;
import org.esa.snap.core.gpf.pointop.WritableSample;

@OperatorMetadata(description="Ungrids ATSR L1B products and extracts geolocation and pixel field of view data.", alias="AATSR.Ungrid", authors="Alasdhair Beaton, Philip Beavis", category="Raster", label="AATSR Ungridding", internal=true)
public class AatsrUngriddingOp
extends PixelOperator {
    @SourceProduct(description="The source product")
    Product sourceProduct;
    @TargetProduct
    Product targetProduct;
    @Parameter
    boolean trimProductEndWhereNoADS;

    protected void prepareInputs() throws OperatorException {
        super.prepareInputs();
        if (!this.sourceProduct.getProductType().equals("ATS_TOA_1P")) {
            throw new OperatorException("Product does not have correct type");
        }
    }

    protected void computePixel(int x, int y, Sample[] sourceSamples, WritableSample[] targetSamples) {
        targetSamples[0].set(sourceSamples[0].getDouble() / 2.0);
        targetSamples[1].set(sourceSamples[1].getDouble() / 2.0);
    }

    protected void configureSourceSamples(SourceSampleConfigurer sampleConfigurer) throws OperatorException {
        sampleConfigurer.defineComputedSample(0, (RasterDataNode)this.sourceProduct.getBandAt(0));
        sampleConfigurer.defineComputedSample(1, (RasterDataNode)this.sourceProduct.getBandAt(1));
    }

    protected Product createTargetProduct() throws OperatorException {
        Product targetProduct = super.createTargetProduct();
        targetProduct.addBand("nadir view latitude", 30);
        targetProduct.addBand("nadir view longitude", 30);
        return targetProduct;
    }

    protected void configureTargetProduct(ProductConfigurer productConfigurer) {
        super.configureTargetProduct(productConfigurer);
        productConfigurer.copyBands(new String[0]);
        productConfigurer.getTargetProduct().setAutoGrouping("nadir:fward");
    }

    protected void configureTargetSamples(TargetSampleConfigurer sampleConfigurer) throws OperatorException {
        sampleConfigurer.defineSample(0, "nadir view latitude");
        sampleConfigurer.defineSample(1, "nadir view longitude");
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(AatsrUngriddingOp.class);
        }
    }
}

