/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.util;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.media.jai.PlanarImage;
import org.esa.snap.core.image.ResolutionLevel;
import org.esa.snap.core.image.SingleBandedOpImage;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.VariableIF;

public class S3ReferencingVariableOpImage
extends SingleBandedOpImage {
    private final Variable referencedIndexVariable;
    private final VariableIF variable;
    private final DimensionValuesProvider dimensionValuesProvider;

    public S3ReferencingVariableOpImage(VariableIF variable, int dataBufferType, int sourceWidth, int sourceHeight, Dimension tileSize, ResolutionLevel level, int[] additionalDimensionIndexes, Variable referencedIndexVariable, String nameOfReferencingDimension, String nameOfDisplayedDimension) {
        super(dataBufferType, sourceWidth, sourceHeight, tileSize, null, level);
        this.variable = variable;
        this.dimensionValuesProvider = this.getDimensionValuesProvider();
        int displayedDimensionIndex = variable.findDimensionIndex(nameOfDisplayedDimension);
        int referencingDimensionIndex = variable.findDimensionIndex(nameOfReferencingDimension);
        this.referencedIndexVariable = referencedIndexVariable;
        int numDetectors = variable.getDimension(referencingDimensionIndex).getLength();
        if (displayedDimensionIndex >= 0) {
            int[] variableOrigin = new int[2];
            variableOrigin[displayedDimensionIndex] = additionalDimensionIndexes[0];
            variableOrigin[referencingDimensionIndex] = 0;
            int[] variableShape = new int[2];
            variableShape[displayedDimensionIndex] = 1;
            variableShape[referencingDimensionIndex] = numDetectors;
            this.dimensionValuesProvider.readValues(variableOrigin, variableShape);
        } else {
            int[] variableOrigin = new int[1];
            variableOrigin[referencingDimensionIndex] = 0;
            int[] variableShape = new int[1];
            variableShape[referencingDimensionIndex] = numDetectors;
            this.dimensionValuesProvider.readValues(variableOrigin, variableShape);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeRect(PlanarImage[] sourceImages, WritableRaster tile, Rectangle rectangle) {
        int[] shape = new int[2];
        int[] origin = new int[2];
        int[] stride = new int[2];
        for (int i = 0; i < 2; ++i) {
            shape[i] = 1;
            origin[i] = 0;
            stride[i] = 1;
        }
        int indexX = this.getIndexX(2);
        int indexY = this.getIndexY(2);
        shape[indexX] = this.getSourceWidth(rectangle.width);
        shape[indexY] = this.getSourceHeight(rectangle.height);
        origin[indexX] = this.getSourceX(rectangle.x) + this.getSourceOriginX();
        origin[indexY] = this.getSourceY(rectangle.y) + this.getSourceOriginY();
        double scale = this.getScale();
        stride[indexX] = (int)scale;
        stride[indexY] = (int)scale;
        Array variableValues = Array.factory((DataType)this.variable.getDataType(), (int[])shape);
        try {
            Section section = new Section(origin, shape, stride);
            NetcdfFile netcdfFile = this.referencedIndexVariable.getParentGroup().getNetcdfFile();
            synchronized (netcdfFile) {
                Array referencedValues = this.referencedIndexVariable.read(section);
                this.dimensionValuesProvider.setVariableValues(referencedValues, variableValues);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        tile.setDataElements(rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.transformStorage(variableValues));
    }

    protected int getIndexX(int rank) {
        return rank - 1;
    }

    protected int getIndexY(int rank) {
        return rank - 2;
    }

    private DimensionValuesProvider getDimensionValuesProvider() {
        switch (this.variable.getDataType()) {
            case FLOAT: {
                return new FloatDimensionValuesProvider();
            }
            case SHORT: {
                return new ShortDimensionValuesProvider();
            }
        }
        return new NullDimensionValuesProvider();
    }

    protected int getSourceOriginX() {
        return 0;
    }

    protected int getSourceOriginY() {
        return 0;
    }

    protected Object transformStorage(Array array) {
        return array.getStorage();
    }

    private static Number getNoDataValue(Variable variable) {
        Attribute attribute = variable.findAttribute("_FillValue");
        if (attribute == null) {
            attribute = variable.findAttribute("missing_value");
        }
        if (attribute != null) {
            return S3ReferencingVariableOpImage.getAttributeValue(attribute);
        }
        return null;
    }

    private static Number getAttributeValue(Attribute attribute) {
        if (attribute.isString()) {
            String stringValue = attribute.getStringValue();
            if (stringValue.endsWith("b")) {
                return Byte.parseByte(stringValue.substring(0, stringValue.length() - 1));
            }
            return Double.parseDouble(stringValue);
        }
        return attribute.getNumericValue();
    }

    private class NullDimensionValuesProvider
    implements DimensionValuesProvider {
        private NullDimensionValuesProvider() {
        }

        @Override
        public void readValues(int[] variableOrigin, int[] variableShape) {
        }

        @Override
        public void setVariableValues(Array referencedValues, Array variableValues) {
        }
    }

    private class ShortDimensionValuesProvider
    implements DimensionValuesProvider {
        private short[] dimensionValues;

        private ShortDimensionValuesProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void readValues(int[] variableOrigin, int[] variableShape) {
            try {
                Section detectorSection = new Section(variableOrigin, variableShape);
                NetcdfFile netcdfFile = S3ReferencingVariableOpImage.this.variable.getParentGroup().getNetcdfFile();
                synchronized (netcdfFile) {
                    Array dimensionValuesArray = S3ReferencingVariableOpImage.this.variable.read(detectorSection);
                    this.dimensionValues = (short[])dimensionValuesArray.copyTo1DJavaArray();
                }
            }
            catch (IOException | InvalidRangeException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void setVariableValues(Array referencedValues, Array variableValues) {
            short noDataValue = S3ReferencingVariableOpImage.getNoDataValue(S3ReferencingVariableOpImage.this.referencedIndexVariable).shortValue();
            int i = 0;
            while ((long)i < referencedValues.getSize()) {
                int detectorIndex = referencedValues.getInt(i);
                if (detectorIndex > -1) {
                    variableValues.setShort(i, this.dimensionValues[detectorIndex]);
                } else {
                    variableValues.setShort(i, noDataValue);
                }
                ++i;
            }
        }
    }

    private class FloatDimensionValuesProvider
    implements DimensionValuesProvider {
        private float[] dimensionValues;

        private FloatDimensionValuesProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void readValues(int[] variableOrigin, int[] variableShape) {
            try {
                Section detectorSection = new Section(variableOrigin, variableShape);
                NetcdfFile netcdfFile = S3ReferencingVariableOpImage.this.variable.getParentGroup().getNetcdfFile();
                synchronized (netcdfFile) {
                    Array dimensionValuesArray = S3ReferencingVariableOpImage.this.variable.read(detectorSection);
                    this.dimensionValues = (float[])dimensionValuesArray.copyTo1DJavaArray();
                }
            }
            catch (IOException | InvalidRangeException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void setVariableValues(Array referencedValues, Array variableValues) {
            float noDataValue = S3ReferencingVariableOpImage.getNoDataValue(S3ReferencingVariableOpImage.this.referencedIndexVariable).floatValue();
            int i = 0;
            while ((long)i < referencedValues.getSize()) {
                int detectorIndex = referencedValues.getInt(i);
                if (detectorIndex > -1) {
                    variableValues.setFloat(i, this.dimensionValues[detectorIndex]);
                } else {
                    variableValues.setFloat(i, noDataValue);
                }
                ++i;
            }
        }
    }

    static interface DimensionValuesProvider {
        public void readValues(int[] var1, int[] var2);

        public void setVariableValues(Array var1, Array var2);
    }
}

