/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.util;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.esa.s3tbx.dataio.s3.util.S3MultiLevelOpImage;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.dataio.netcdf.util.DataTypeUtils;
import org.esa.snap.dataio.netcdf.util.NetcdfFileOpener;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class S3NetcdfReader {
    private static final String product_type = "product_type";
    private static final String flag_values = "flag_values";
    private static final String flag_masks = "flag_masks";
    private static final String flag_meanings = "flag_meanings";
    private static final String fillValue = "_FillValue";
    private final NetcdfFile netcdfFile;
    private final String pathToFile;

    public S3NetcdfReader(String pathToFile) throws IOException {
        this.netcdfFile = NetcdfFileOpener.open((Object)pathToFile);
        this.pathToFile = pathToFile;
    }

    public Product readProduct() throws IOException {
        String productType = this.readProductType();
        int productWidth = this.getWidth();
        int productHeight = this.getHeight();
        File file = new File(this.pathToFile);
        Product product = new Product(FileUtils.getFilenameWithoutExtension((File)file), productType, productWidth, productHeight);
        product.setFileLocation(file);
        this.addGlobalMetadata(product);
        this.addBands(product);
        this.addGeoCoding(product);
        for (Band band : product.getBands()) {
            if (band instanceof VirtualBand) continue;
            band.setSourceImage(this.createSourceImage(band));
        }
        return product;
    }

    protected void addGeoCoding(Product product) {
    }

    protected String[] getSeparatingDimensions() {
        return new String[0];
    }

    public String[] getSuffixesForSeparatingDimensions() {
        return new String[0];
    }

    protected String[][] getRowColumnNamePairs() {
        return new String[][]{{"rows", "columns"}, {"tie_rows", "tie_columns"}};
    }

    protected RenderedImage createSourceImage(Band band) {
        Dimension heightDimension;
        String bandName = band.getName();
        String variableName = bandName;
        if (variableName.endsWith("_lsb")) {
            variableName = variableName.substring(0, variableName.indexOf("_lsb"));
        } else if (variableName.endsWith("_msb")) {
            variableName = variableName.substring(0, variableName.indexOf("_msb"));
        }
        Variable variable = null;
        ArrayList<String> dimensionNameList = new ArrayList<String>();
        ArrayList<Integer> dimensionIndexList = new ArrayList<Integer>();
        String[] separatingDimensions = this.getSeparatingDimensions();
        String[] suffixesForSeparatingThirdDimensions = this.getSuffixesForSeparatingDimensions();
        int lowestSuffixIndex = Integer.MAX_VALUE;
        for (int i = 0; i < separatingDimensions.length; ++i) {
            String dimension = separatingDimensions[i];
            String suffix = suffixesForSeparatingThirdDimensions[i];
            if (!bandName.contains(suffix)) continue;
            int suffixIndex = bandName.indexOf(suffix) - 1;
            if (suffixIndex < lowestSuffixIndex) {
                lowestSuffixIndex = suffixIndex;
            }
            dimensionNameList.add(dimension);
            dimensionIndexList.add(this.getDimensionIndexFromBandName(bandName));
        }
        if (lowestSuffixIndex < bandName.length()) {
            variableName = bandName.substring(0, lowestSuffixIndex);
            variable = this.netcdfFile.findVariable(variableName);
        }
        if (variable == null) {
            variable = this.netcdfFile.findVariable(variableName);
        }
        Dimension widthDimension = this.getWidthDimension();
        int xIndex = -1;
        int yIndex = -1;
        if (widthDimension != null) {
            xIndex = variable.findDimensionIndex(widthDimension.getFullName());
        }
        if ((heightDimension = this.getHeightDimension()) != null) {
            yIndex = variable.findDimensionIndex(heightDimension.getFullName());
        }
        String[] dimensionNames = dimensionNameList.toArray(new String[dimensionNameList.size()]);
        int[] dimensionIndexes = new int[dimensionIndexList.size()];
        for (int i = 0; i < dimensionIndexList.size(); ++i) {
            dimensionIndexes[i] = (Integer)dimensionIndexList.get(i);
        }
        return new S3MultiLevelOpImage((RasterDataNode)band, variable, dimensionNames, dimensionIndexes, xIndex, yIndex);
    }

    protected int getDimensionIndexFromBandName(String bandName) {
        return Integer.parseInt(bandName.substring(bandName.lastIndexOf("_") + 1)) - 1;
    }

    private void addGlobalMetadata(Product product) {
        MetadataElement globalAttributesElement = new MetadataElement("Global_Attributes");
        List globalAttributes = this.netcdfFile.getGlobalAttributes();
        for (Attribute attribute : globalAttributes) {
            if (attribute.getValues() == null) continue;
            int type = DataTypeUtils.getEquivalentProductDataType((DataType)attribute.getDataType(), (boolean)false, (boolean)false);
            ProductData attributeData = this.getAttributeData(attribute, type);
            MetadataAttribute metadataAttribute = new MetadataAttribute(attribute.getFullName(), attributeData, true);
            globalAttributesElement.addAttribute(metadataAttribute);
        }
        product.getMetadataRoot().addElement(globalAttributesElement);
        MetadataElement variableAttributesElement = new MetadataElement("Variable_Attributes");
        product.getMetadataRoot().addElement(variableAttributesElement);
    }

    protected void addBands(Product product) {
        List variables = this.netcdfFile.getVariables();
        for (Variable variable : variables) {
            String[][] rowColumnNamePairs;
            for (String[] rowColumnNamePair : rowColumnNamePairs = this.getRowColumnNamePairs()) {
                if (variable.findDimensionIndex(rowColumnNamePair[0]) == -1 || variable.findDimensionIndex(rowColumnNamePair[1]) == -1) continue;
                String variableName = variable.getFullName();
                String[] dimensions = this.getSeparatingDimensions();
                String[] suffixes = this.getSuffixesForSeparatingDimensions();
                boolean variableMustStillBeAdded = true;
                for (int i = 0; i < dimensions.length; ++i) {
                    String dimensionName = dimensions[i];
                    if (variable.findDimensionIndex(dimensionName) == -1) continue;
                    Dimension dimension = variable.getDimension(variable.findDimensionIndex(dimensionName));
                    for (int j = 0; j < dimension.getLength(); ++j) {
                        this.addVariableAsBand(product, variable, variableName + "_" + suffixes[i] + "_" + (j + 1), false);
                    }
                    variableMustStillBeAdded = false;
                    break;
                }
                if (!variableMustStillBeAdded) continue;
                this.addVariableAsBand(product, variable, variableName, false);
            }
            this.addVariableMetadata(variable, product);
        }
    }

    private static int getRasterDataType(Variable variable) {
        int rasterDataType = DataTypeUtils.getRasterDataType((Variable)variable);
        if (rasterDataType == -1 && variable.getDataType() == DataType.LONG) {
            rasterDataType = variable.isUnsigned() ? 22 : 12;
        }
        return rasterDataType;
    }

    protected void addVariableAsBand(Product product, Variable variable, String variableName, boolean synthetic) {
        int type = S3NetcdfReader.getRasterDataType(variable);
        if (variable.getDataType() == DataType.LONG) {
            Band lowerBand = product.addBand(variableName + "_lsb", type);
            lowerBand.setDescription(variable.getDescription() + "(least significant bytes)");
            lowerBand.setUnit(variable.getUnitsString());
            lowerBand.setScalingFactor(S3NetcdfReader.getScalingFactor(variable));
            lowerBand.setScalingOffset(S3NetcdfReader.getAddOffset(variable));
            lowerBand.setSynthetic(synthetic);
            this.addFillValue(lowerBand, variable);
            this.addSampleCodings(product, lowerBand, variable, false);
            Band upperBand = product.addBand(variableName + "_msb", type);
            upperBand.setDescription(variable.getDescription() + "(most significant bytes)");
            upperBand.setUnit(variable.getUnitsString());
            upperBand.setScalingFactor(S3NetcdfReader.getScalingFactor(variable));
            upperBand.setScalingOffset(S3NetcdfReader.getAddOffset(variable));
            upperBand.setSynthetic(synthetic);
            this.addFillValue(upperBand, variable);
            this.addSampleCodings(product, upperBand, variable, true);
        } else {
            Band band = product.addBand(variableName, type);
            band.setDescription(variable.getDescription());
            band.setUnit(variable.getUnitsString());
            band.setScalingFactor(S3NetcdfReader.getScalingFactor(variable));
            band.setScalingOffset(S3NetcdfReader.getAddOffset(variable));
            band.setSynthetic(synthetic);
            this.addFillValue(band, variable);
            this.addSampleCodings(product, band, variable, false);
        }
    }

    protected void addFillValue(Band band, Variable variable) {
        Attribute fillValueAttribute = variable.findAttribute(fillValue);
        if (fillValueAttribute != null) {
            band.setNoDataValue(fillValueAttribute.getNumericValue().doubleValue());
            band.setNoDataValueUsed(true);
        }
    }

    protected void addSampleCodings(Product product, Band band, Variable variable, boolean msb) {
        Attribute flagValuesAttribute = variable.findAttribute(flag_values);
        Attribute flagMasksAttribute = variable.findAttribute(flag_masks);
        Attribute flagMeaningsAttribute = variable.findAttribute(flag_meanings);
        if (flagValuesAttribute != null && flagMasksAttribute != null) {
            FlagCoding flagCoding = this.getFlagCoding(product, band.getName(), flagMeaningsAttribute, flagValuesAttribute, flagMasksAttribute, msb);
            band.setSampleCoding((SampleCoding)flagCoding);
        } else if (flagValuesAttribute != null) {
            IndexCoding indexCoding = this.getIndexCoding(product, band.getName(), flagMeaningsAttribute, flagValuesAttribute, msb);
            band.setSampleCoding((SampleCoding)indexCoding);
        } else if (flagMasksAttribute != null) {
            FlagCoding flagCoding = this.getFlagCoding(product, band.getName(), flagMeaningsAttribute, flagMasksAttribute, msb);
            band.setSampleCoding((SampleCoding)flagCoding);
        }
    }

    private IndexCoding getIndexCoding(Product product, String indexCodingName, Attribute flagMeaningsAttribute, Attribute flagValuesAttribute, boolean msb) {
        IndexCoding indexCoding = new IndexCoding(indexCodingName);
        S3NetcdfReader.addSamples((SampleCoding)indexCoding, flagMeaningsAttribute, flagValuesAttribute, msb);
        if (!product.getIndexCodingGroup().contains(indexCodingName)) {
            product.getIndexCodingGroup().add((ProductNode)indexCoding);
        }
        return indexCoding;
    }

    private FlagCoding getFlagCoding(Product product, String flagCodingName, Attribute flagMeaningsAttribute, Attribute flagMasksAttribute, boolean msb) {
        FlagCoding flagCoding = new FlagCoding(flagCodingName);
        S3NetcdfReader.addSamples((SampleCoding)flagCoding, flagMeaningsAttribute, flagMasksAttribute, msb);
        if (!product.getFlagCodingGroup().contains(flagCodingName)) {
            product.getFlagCodingGroup().add((ProductNode)flagCoding);
        }
        return flagCoding;
    }

    private FlagCoding getFlagCoding(Product product, String flagCodingName, Attribute flagMeaningsAttribute, Attribute flagValuesAttribute, Attribute flagMasksAttribute, boolean msb) {
        FlagCoding flagCoding = new FlagCoding(flagCodingName);
        S3NetcdfReader.addSamples((SampleCoding)flagCoding, flagMeaningsAttribute, flagValuesAttribute, flagMasksAttribute, msb);
        if (!product.getFlagCodingGroup().contains(flagCodingName)) {
            product.getFlagCodingGroup().add((ProductNode)flagCoding);
        }
        return flagCoding;
    }

    private static void addSamples(SampleCoding sampleCoding, Attribute sampleMeanings, Attribute sampleValues, boolean msb) {
        String[] meanings = S3NetcdfReader.getSampleMeanings(sampleMeanings);
        int sampleCount = Math.min(meanings.length, sampleValues.getLength());
        block6: for (int i = 0; i < sampleCount; ++i) {
            String sampleName = S3NetcdfReader.replaceNonWordCharacters(meanings[i]);
            switch (sampleValues.getDataType()) {
                case BYTE: {
                    sampleCoding.addSample(sampleName, (int)DataType.unsignedByteToShort((byte)sampleValues.getNumericValue(i).byteValue()), null);
                    continue block6;
                }
                case SHORT: {
                    sampleCoding.addSample(sampleName, DataType.unsignedShortToInt((short)sampleValues.getNumericValue(i).shortValue()), null);
                    continue block6;
                }
                case INT: {
                    sampleCoding.addSample(sampleName, sampleValues.getNumericValue(i).intValue(), null);
                    continue block6;
                }
                case LONG: {
                    long shiftedValue;
                    long longValue = sampleValues.getNumericValue(i).longValue();
                    if (msb) {
                        shiftedValue = longValue >>> 32;
                        if (shiftedValue <= 0L) continue block6;
                        sampleCoding.addSample(sampleName, (int)shiftedValue, null);
                        continue block6;
                    }
                    shiftedValue = longValue & 0xFFFFFFFFL;
                    if (shiftedValue <= 0L && longValue != 0L) continue block6;
                    sampleCoding.addSample(sampleName, (int)shiftedValue, null);
                }
            }
        }
    }

    private static void addSamples(SampleCoding sampleCoding, Attribute sampleMeanings, Attribute sampleValues, Attribute sampleMasks, boolean msb) {
        String[] meanings = S3NetcdfReader.getSampleMeanings(sampleMeanings);
        int sampleCount = Math.min(meanings.length, sampleMasks.getLength());
        block6: for (int i = 0; i < sampleCount; ++i) {
            String sampleName = S3NetcdfReader.replaceNonWordCharacters(meanings[i]);
            switch (sampleMasks.getDataType()) {
                case BYTE: {
                    int[] byteValues = new int[]{DataType.unsignedByteToShort((byte)sampleMasks.getNumericValue(i).byteValue()), DataType.unsignedByteToShort((byte)sampleValues.getNumericValue(i).byteValue())};
                    if (byteValues[0] == byteValues[1]) {
                        sampleCoding.addSample(sampleName, byteValues[0], null);
                        continue block6;
                    }
                    sampleCoding.addSamples(sampleName, byteValues, null);
                    continue block6;
                }
                case SHORT: {
                    int[] shortValues = new int[]{DataType.unsignedShortToInt((short)sampleMasks.getNumericValue(i).shortValue()), DataType.unsignedShortToInt((short)sampleValues.getNumericValue(i).shortValue())};
                    if (shortValues[0] == shortValues[1]) {
                        sampleCoding.addSample(sampleName, shortValues[0], null);
                        continue block6;
                    }
                    sampleCoding.addSamples(sampleName, shortValues, null);
                    continue block6;
                }
                case INT: {
                    int[] intValues = new int[]{sampleMasks.getNumericValue(i).intValue(), sampleValues.getNumericValue(i).intValue()};
                    if (intValues[0] == intValues[1]) {
                        sampleCoding.addSample(sampleName, intValues[0], null);
                    } else {
                        sampleCoding.addSamples(sampleName, intValues, null);
                    }
                    sampleCoding.addSamples(sampleName, intValues, null);
                    continue block6;
                }
                case LONG: {
                    int[] intLongValues;
                    long[] longValues = new long[]{sampleMasks.getNumericValue(i).longValue(), sampleValues.getNumericValue(i).longValue()};
                    if (msb) {
                        intLongValues = new int[]{(int)(longValues[0] >>> 32), (int)(longValues[1] >>> 32)};
                        if (longValues[0] <= 0L) continue block6;
                        if (intLongValues[0] == intLongValues[1]) {
                            sampleCoding.addSample(sampleName, intLongValues[0], null);
                            continue block6;
                        }
                        sampleCoding.addSamples(sampleName, intLongValues, null);
                        continue block6;
                    }
                    intLongValues = new int[]{(int)(longValues[0] & 0xFFFFFFFFL), (int)(longValues[1] & 0xFFFFFFFFL)};
                    if (intLongValues[0] <= 0 && longValues[0] != 0L) continue block6;
                    if (intLongValues[0] == intLongValues[1]) {
                        sampleCoding.addSample(sampleName, intLongValues[0], null);
                        continue block6;
                    }
                    sampleCoding.addSamples(sampleName, intLongValues, null);
                }
            }
        }
    }

    private static String[] getSampleMeanings(Attribute sampleMeanings) {
        int sampleMeaningsCount = sampleMeanings.getLength();
        if (sampleMeaningsCount == 0) {
            return new String[sampleMeaningsCount];
        }
        if (sampleMeaningsCount > 1) {
            String[] strings = new String[sampleMeaningsCount];
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = sampleMeanings.getStringValue(i);
            }
            return strings;
        }
        return sampleMeanings.getStringValue().split(" ");
    }

    static String replaceNonWordCharacters(String flagName) {
        return flagName.replaceAll("\\W+", "_");
    }

    protected static double getScalingFactor(Variable variable) {
        Attribute attribute = variable.findAttribute("scale_factor");
        if (attribute == null) {
            attribute = variable.findAttribute("slope");
        }
        if (attribute == null) {
            attribute = variable.findAttribute("scaling_factor");
        }
        if (attribute != null) {
            return S3NetcdfReader.getAttributeValue(attribute).doubleValue();
        }
        return 1.0;
    }

    protected static double getAddOffset(Variable variable) {
        Attribute attribute = variable.findAttribute("add_offset");
        if (attribute == null) {
            attribute = variable.findAttribute("intercept");
        }
        if (attribute != null) {
            return S3NetcdfReader.getAttributeValue(attribute).doubleValue();
        }
        return 0.0;
    }

    private static Number getAttributeValue(Attribute attribute) {
        if (attribute.isString()) {
            String stringValue = attribute.getStringValue();
            if (stringValue.endsWith("b")) {
                return Byte.parseByte(stringValue.substring(0, stringValue.length() - 1));
            }
            return Double.parseDouble(stringValue);
        }
        return attribute.getNumericValue();
    }

    protected void addVariableMetadata(Variable variable, Product product) {
        MetadataElement variableElement = new MetadataElement(variable.getFullName());
        List attributes = variable.getAttributes();
        for (Attribute attribute : attributes) {
            if (attribute.getFullName().equals(flag_meanings)) {
                String[] flagMeanings = attribute.getStringValue().split(" ");
                for (int i = 0; i < flagMeanings.length; ++i) {
                    String flagMeaning = flagMeanings[i];
                    ProductData attributeData = ProductData.createInstance((String)flagMeaning);
                    MetadataAttribute metadataAttribute = new MetadataAttribute(attribute.getFullName() + "." + i, attributeData, true);
                    variableElement.addAttribute(metadataAttribute);
                }
                continue;
            }
            int type = DataTypeUtils.getEquivalentProductDataType((DataType)attribute.getDataType(), (boolean)false, (boolean)false);
            if (type == -1 && attribute.getDataType() == DataType.LONG) {
                int n = type = variable.isUnsigned() ? 22 : 12;
            }
            if (attribute.getValues() == null) continue;
            ProductData attributeData = this.getAttributeData(attribute, type);
            MetadataAttribute metadataAttribute = new MetadataAttribute(attribute.getFullName(), attributeData, true);
            variableElement.addAttribute(metadataAttribute);
        }
        List variableDimensions = variable.getDimensions();
        if (variableDimensions.size() == 1) {
            try {
                Object data = variable.read().copyTo1DJavaArray();
                MetadataAttribute variableAttribute = null;
                if (data instanceof float[]) {
                    variableAttribute = new MetadataAttribute("value", ProductData.createInstance((float[])((float[])data)), true);
                } else if (data instanceof short[]) {
                    variableAttribute = new MetadataAttribute("value", ProductData.createInstance((short[])((short[])data)), true);
                } else if (data instanceof long[]) {
                    variableAttribute = new MetadataAttribute("value", ProductData.createInstance((long[])((long[])data)), true);
                }
                if (variableAttribute != null) {
                    variableAttribute.setUnit(variable.getUnitsString());
                    variableAttribute.setDescription(variable.getDescription());
                    variableElement.addAttribute(variableAttribute);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        product.getMetadataRoot().getElement("Variable_Attributes").addElement(variableElement);
    }

    protected ProductData getAttributeData(Attribute attribute, int type) {
        Array attributeValues = attribute.getValues();
        ProductData productData = null;
        switch (type) {
            case 41: {
                productData = ProductData.createInstance((String)attributeValues.toString());
                break;
            }
            case 10: {
                productData = ProductData.createInstance((byte[])((byte[])attributeValues.copyTo1DJavaArray()));
                break;
            }
            case 11: {
                productData = ProductData.createInstance((short[])((short[])attributeValues.copyTo1DJavaArray()));
                break;
            }
            case 12: {
                Object array = attributeValues.copyTo1DJavaArray();
                if (array instanceof long[]) {
                    long[] longArray = (long[])array;
                    int[] newArray = new int[longArray.length];
                    for (int i = 0; i < longArray.length; ++i) {
                        newArray[i] = (int)longArray[i];
                    }
                    array = newArray;
                }
                productData = ProductData.createInstance((int[])((int[])array));
                break;
            }
            case 22: {
                Object array = attributeValues.copyTo1DJavaArray();
                if (array instanceof long[]) {
                    long[] longArray = (long[])array;
                    int[] newArray = new int[longArray.length];
                    for (int i = 0; i < longArray.length; ++i) {
                        newArray[i] = (int)longArray[i];
                    }
                    array = newArray;
                }
                productData = ProductData.createInstance((int[])((int[])array));
                break;
            }
            case 30: {
                productData = ProductData.createInstance((float[])((float[])attributeValues.copyTo1DJavaArray()));
                break;
            }
            case 31: {
                productData = ProductData.createInstance((double[])((double[])attributeValues.copyTo1DJavaArray()));
                break;
            }
        }
        return productData;
    }

    int getWidth() {
        Dimension widthDimension = this.getWidthDimension();
        if (widthDimension != null) {
            return widthDimension.getLength();
        }
        return 0;
    }

    private Dimension getWidthDimension() {
        String[][] rowColumnNamePairs;
        for (String[] rowColumnNamePair : rowColumnNamePairs = this.getRowColumnNamePairs()) {
            Dimension widthDimension = this.netcdfFile.findDimension(rowColumnNamePair[1]);
            if (widthDimension == null) continue;
            return widthDimension;
        }
        return null;
    }

    int getHeight() {
        Dimension heightDimension = this.getHeightDimension();
        if (heightDimension != null) {
            return heightDimension.getLength();
        }
        return 0;
    }

    private Dimension getHeightDimension() {
        String[][] rowColumnNamePairs;
        for (String[] rowColumnNamePair : rowColumnNamePairs = this.getRowColumnNamePairs()) {
            Dimension heightDimension = this.netcdfFile.findDimension(rowColumnNamePair[0]);
            if (heightDimension == null) continue;
            return heightDimension;
        }
        return null;
    }

    String readProductType() {
        Attribute typeAttribute = this.netcdfFile.findGlobalAttribute(product_type);
        if (typeAttribute == null) {
            typeAttribute = this.netcdfFile.findGlobalAttribute("Conventions");
        }
        String type = null;
        if (typeAttribute != null) {
            type = typeAttribute.getStringValue();
        }
        String productType = "NetCDF";
        if (type != null && type.trim().length() > 0) {
            productType = type.trim();
        }
        return productType;
    }

    protected NetcdfFile getNetcdfFile() {
        return this.netcdfFile;
    }
}

