/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.util;

import com.bc.ceres.glevel.MultiLevelModel;
import java.awt.Dimension;
import java.awt.image.RenderedImage;
import org.esa.s3tbx.dataio.s3.util.S3ReferencingVariableOpImage;
import org.esa.s3tbx.dataio.s3.util.S3VariableOpImage;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.image.ResolutionLevel;
import org.esa.snap.dataio.netcdf.util.AbstractNetcdfMultiLevelImage;
import ucar.nc2.Variable;
import ucar.nc2.VariableIF;

public class S3MultiLevelOpImage
extends AbstractNetcdfMultiLevelImage {
    private final Variable variable;
    private final int[] dimensionIndexes;
    private final String[] dimensionNames;
    private Variable referencedIndexVariable;
    private String nameOfReferencingIndexDimension;
    private String nameOfDisplayedDimension;
    private int xIndex;
    private int yIndex;

    public S3MultiLevelOpImage(RasterDataNode rasterDataNode, Variable variable, String[] dimensionNames, int[] dimensionIndexes, int xIndex, int yIndex) {
        super(rasterDataNode);
        this.variable = variable;
        this.dimensionNames = dimensionNames;
        this.dimensionIndexes = dimensionIndexes;
        this.xIndex = xIndex;
        this.yIndex = yIndex;
    }

    public S3MultiLevelOpImage(RasterDataNode rasterDataNode, Variable variable, String[] dimensionNames, int[] dimensionIndexes, Variable referencedIndexVariable, String nameOfReferencingIndexDimension, String nameOfDisplayedDimension) {
        super(rasterDataNode);
        this.variable = variable;
        this.dimensionNames = dimensionNames;
        this.dimensionIndexes = dimensionIndexes;
        this.referencedIndexVariable = referencedIndexVariable;
        this.nameOfReferencingIndexDimension = nameOfReferencingIndexDimension;
        this.nameOfDisplayedDimension = nameOfDisplayedDimension;
    }

    protected RenderedImage createImage(int level) {
        RasterDataNode rasterDataNode = this.getRasterDataNode();
        int dataBufferType = ImageManager.getDataBufferType((int)rasterDataNode.getDataType());
        int sceneRasterWidth = rasterDataNode.getRasterWidth();
        int sceneRasterHeight = rasterDataNode.getRasterHeight();
        ResolutionLevel resolutionLevel = ResolutionLevel.create((MultiLevelModel)this.getModel(), (int)level);
        Dimension imageTileSize = new Dimension(this.getTileWidth(), this.getTileHeight());
        if (this.referencedIndexVariable != null && this.nameOfReferencingIndexDimension != null && this.nameOfDisplayedDimension != null) {
            return new S3ReferencingVariableOpImage((VariableIF)this.variable, dataBufferType, sceneRasterWidth, sceneRasterHeight, imageTileSize, resolutionLevel, this.dimensionIndexes, this.referencedIndexVariable, this.nameOfReferencingIndexDimension, this.nameOfDisplayedDimension);
        }
        if (rasterDataNode.getName().endsWith("_msb")) {
            return S3VariableOpImage.createS3VariableOpImage((VariableIF)this.variable, dataBufferType, sceneRasterWidth, sceneRasterHeight, imageTileSize, resolutionLevel, this.dimensionNames, this.dimensionIndexes, this.xIndex, this.yIndex, true);
        }
        if (rasterDataNode.getName().endsWith("_lsb")) {
            return S3VariableOpImage.createS3VariableOpImage((VariableIF)this.variable, dataBufferType, sceneRasterWidth, sceneRasterHeight, imageTileSize, resolutionLevel, this.dimensionNames, this.dimensionIndexes, this.xIndex, this.yIndex, false);
        }
        if ((this.variable.getFullName().contains("row_corresp") || this.variable.getFullName().contains("col_corresp")) && rasterDataNode.getDataType() == 22) {
            return new S3VariableOpImage((VariableIF)this.variable, 4, sceneRasterWidth, sceneRasterHeight, imageTileSize, resolutionLevel, this.dimensionNames, this.dimensionIndexes, this.xIndex, this.yIndex, S3VariableOpImage.ArrayConverter.UINTCONVERTER);
        }
        return new S3VariableOpImage((VariableIF)this.variable, dataBufferType, sceneRasterWidth, sceneRasterHeight, imageTileSize, resolutionLevel, this.dimensionNames, this.dimensionIndexes, this.xIndex, this.yIndex);
    }
}

