/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.util;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.List;
import org.esa.s3tbx.dataio.s3.util.S3MultiLevelOpImage;
import org.esa.s3tbx.dataio.s3.util.S3NetcdfReader;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class InstrumentDataReader
extends S3NetcdfReader {
    private static final String detector_index_name = "detector_index";
    private Variable detectorIndexVariable;

    public InstrumentDataReader(String pathToFile) throws IOException {
        super(pathToFile);
    }

    @Override
    protected void addBands(Product product) {
        NetcdfFile netcdfFile = this.getNetcdfFile();
        this.detectorIndexVariable = netcdfFile.findVariable(detector_index_name);
        if (this.detectorIndexVariable == null) {
            return;
        }
        this.addVariableAsBand(product, this.detectorIndexVariable, detector_index_name, false);
        this.addVariableMetadata(this.detectorIndexVariable, product);
        List variables = netcdfFile.getVariables();
        for (Variable variable : variables) {
            int bandsDimensionIndex = variable.findDimensionIndex("bands");
            int detectorsDimensionIndex = variable.findDimensionIndex("detectors");
            if (bandsDimensionIndex != -1 && detectorsDimensionIndex != -1) {
                int numBands = variable.getDimension(bandsDimensionIndex).getLength();
                for (int i = 1; i <= numBands; ++i) {
                    this.addVariableAsBand(product, variable, variable.getFullName() + "_band_" + i, true);
                }
            } else if (variable.getDimensions().size() == 1 && detectorsDimensionIndex != -1) {
                this.addVariableAsBand(product, variable, variable.getFullName(), true);
            }
            this.addVariableMetadata(variable, product);
        }
    }

    @Override
    protected RenderedImage createSourceImage(Band band) {
        Variable variable;
        String bandName;
        if (band.getName().equals(detector_index_name)) {
            return super.createSourceImage(band);
        }
        String variableName = bandName = band.getName();
        int dimensionIndex = -1;
        String dimensionName = "";
        if (bandName.contains("_band")) {
            int suffixIndex = variableName.indexOf("_band");
            variableName = bandName.substring(0, suffixIndex);
            variable = this.getNetcdfFile().findVariable(variableName);
            dimensionName = "bands";
            dimensionIndex = Integer.parseInt(bandName.substring(suffixIndex + 6)) - 1;
        } else {
            variable = this.getNetcdfFile().findVariable(variableName);
        }
        return new S3MultiLevelOpImage((RasterDataNode)band, variable, new String[]{dimensionName}, new int[]{dimensionIndex}, this.detectorIndexVariable, "detectors", dimensionName);
    }

    @Override
    protected void addVariableMetadata(Variable variable, Product product) {
        super.addVariableMetadata(variable, product);
        if (variable.getRank() == 2 && variable.getDimension(0).getFullName().equals("bands")) {
            try {
                String variableName = variable.getFullName();
                MetadataElement variableElement = product.getMetadataRoot().getElement("Variable_Attributes").getElement(variableName);
                float[][] contentMatrix = (float[][])variable.read().copyToNDJavaArray();
                int length = contentMatrix.length;
                for (int i = 0; i < length; ++i) {
                    MetadataElement xElement = new MetadataElement(this.getMetadataElementName(variableName) + " for band " + (i + 1));
                    ProductData content = ProductData.createInstance((float[])contentMatrix[i]);
                    MetadataAttribute covarianceAttribute = new MetadataAttribute(this.getMetadataAttributeName(variableName), content, true);
                    xElement.addAttribute(covarianceAttribute);
                    variableElement.addElement(xElement);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String getMetadataElementName(String attributeName) {
        switch (attributeName) {
            case "relative_spectral_covariance": {
                return "Covariances";
            }
            case "lambda0": {
                return "Central wavelengths";
            }
            case "FWHM": {
                return "Bandwidths";
            }
            case "solar_flux": {
                return "Solar fluxes";
            }
        }
        return "";
    }

    private String getMetadataAttributeName(String attributeName) {
        switch (attributeName) {
            case "relative_spectral_covariance": {
                return "Covariance";
            }
            case "lambda0": {
                return "Central wavelength";
            }
            case "FWHM": {
                return "Bandwidths";
            }
            case "solar_flux": {
                return "Solar flux";
            }
        }
        return "";
    }
}

