/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.util;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ColorProvider {
    private int colourCounter = 0;
    private int numberOfIntermediateSamplePoints = 0;
    private int thirdPowerOfCurrentDivisions;
    private int numberOfTotalSamplePoints = 2;
    private Map<String, Color> predefinedColors;

    public ColorProvider() {
        this.evaluateMaxNumberOfSamplePointsForDivision();
        this.setupReservedColors();
    }

    private void setupReservedColors() {
        this.predefinedColors = new HashMap<String, Color>();
        this.predefinedColors.put("coastline", new Color(255, 0, 0));
        this.predefinedColors.put("water", new Color(0, 63, 255));
        this.predefinedColors.put("land", new Color(0, 127, 63));
        this.predefinedColors.put("lake", new Color(0, 127, 255));
        this.predefinedColors.put("ocean", new Color(0, 0, 191));
        this.predefinedColors.put("snow", new Color(255, 255, 255));
        this.predefinedColors.put("ice", new Color(191, 255, 255));
        this.predefinedColors.put("cloud", new Color(191, 191, 191));
    }

    private void evaluateMaxNumberOfSamplePointsForDivision() {
        this.thirdPowerOfCurrentDivisions = (int)Math.pow(this.numberOfTotalSamplePoints, 3.0);
    }

    private Color getPredefinedColor(String maskName) {
        String maskNameToLowerCase = maskName.toLowerCase();
        Set<Map.Entry<String, Color>> entries = this.predefinedColors.entrySet();
        for (Map.Entry<String, Color> entry : entries) {
            if (!maskNameToLowerCase.contains(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public Color getMaskColor(String maskName) {
        Color color = this.getPredefinedColor(maskName);
        while (color == null) {
            int redStep = 0;
            int greenStep = 0;
            int blueStep = 0;
            double stepSize = 255.0;
            while (redStep % 2 == 0 && greenStep % 2 == 0 && blueStep % 2 == 0) {
                this.updateDivision();
                stepSize = 255.0 / (double)(this.numberOfIntermediateSamplePoints + 1);
                redStep = this.colourCounter / (this.numberOfTotalSamplePoints * this.numberOfTotalSamplePoints) % this.numberOfTotalSamplePoints;
                greenStep = this.colourCounter / this.numberOfTotalSamplePoints % this.numberOfTotalSamplePoints;
                blueStep = this.colourCounter % this.numberOfTotalSamplePoints;
                ++this.colourCounter;
            }
            Color candidateColor = new Color((int)((double)redStep * stepSize), (int)((double)greenStep * stepSize), (int)((double)blueStep * stepSize));
            if (this.isPredefinedColor(candidateColor)) continue;
            color = candidateColor;
        }
        return color;
    }

    private boolean isPredefinedColor(Color color) {
        for (Color predefinedColor : this.predefinedColors.values()) {
            if (!predefinedColor.equals(color)) continue;
            return true;
        }
        return false;
    }

    private void updateDivision() {
        if (this.colourCounter > this.thirdPowerOfCurrentDivisions) {
            this.numberOfIntermediateSamplePoints = this.numberOfIntermediateSamplePoints * 2 + 1;
            this.numberOfTotalSamplePoints = this.numberOfIntermediateSamplePoints + 2;
            this.evaluateMaxNumberOfSamplePointsForDivision();
            this.colourCounter = 0;
        }
    }
}

