/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.synergy;

import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.media.jai.BorderExtender;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import org.esa.s3tbx.dataio.s3.AbstractProductFactory;
import org.esa.s3tbx.dataio.s3.Manifest;
import org.esa.s3tbx.dataio.s3.Sentinel3ProductReader;
import org.esa.s3tbx.dataio.s3.synergy.VgtReader;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.image.SourceImageScaler;

public class VgtProductFactory
extends AbstractProductFactory {
    public VgtProductFactory(Sentinel3ProductReader productReader) {
        super(productReader);
    }

    @Override
    protected List<String> getFileNames(Manifest manifest) {
        return manifest.getFileNames(new String[0]);
    }

    @Override
    protected void configureTargetNode(Band sourceBand, RasterDataNode targetNode) {
        MetadataElement metadataElement;
        MetadataElement variableAttributes;
        if (targetNode instanceof Band && (variableAttributes = sourceBand.getProduct().getMetadataRoot().getElement("Variable_Attributes")) != null && (metadataElement = variableAttributes.getElement(sourceBand.getName())) != null) {
            MetadataAttribute wavelengthAttribute;
            MetadataAttribute bandwidthAttribute = metadataElement.getAttribute("bandwidth");
            if (bandwidthAttribute != null) {
                ((Band)targetNode).setSpectralBandwidth(bandwidthAttribute.getData().getElemFloat());
            }
            if ((wavelengthAttribute = metadataElement.getAttribute("wavelength")) != null) {
                ((Band)targetNode).setSpectralWavelength(wavelengthAttribute.getData().getElemFloat());
            }
        }
    }

    protected Band addSpecialNode(Product masterProduct, Band sourceBand, Product targetProduct) {
        Band targetBand = VgtProductFactory.copyBand(sourceBand, targetProduct, false);
        RenderingHints renderingHints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
        MultiLevelImage sourceImage = sourceBand.getSourceImage();
        float[] scalings = new float[]{(float)targetBand.getRasterWidth() / (float)sourceBand.getRasterWidth(), (float)targetBand.getRasterHeight() / (float)sourceBand.getRasterHeight()};
        MultiLevelImage scaledImage = SourceImageScaler.scaleMultiLevelImage((MultiLevelImage)targetBand.getSourceImage(), (MultiLevelImage)sourceImage, (float[])scalings, null, (RenderingHints)renderingHints, (double)sourceBand.getNoDataValue(), (Interpolation)Interpolation.getInstance((int)0));
        targetBand.setSourceImage(scaledImage);
        return targetBand;
    }

    @Override
    protected Product readProduct(String fileName) throws IOException {
        File file = new File(this.getInputFileParentDirectory(), fileName);
        if (!file.exists()) {
            return null;
        }
        VgtReader reader = new VgtReader(file.getAbsolutePath());
        return reader.readProduct();
    }
}

