/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.synergy;

import java.awt.geom.Point2D;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.AbstractGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Scene;
import org.esa.snap.core.dataop.maptransf.Datum;
import org.esa.snap.core.transform.GeoCodingMathTransform;
import org.esa.snap.core.transform.MathTransform2D;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class SynL1CSceneTransformGeoCoding
extends AbstractGeoCoding {
    private final GeoCoding wrappedGeoCoding;
    private final MathTransform2D sceneToModelTransform;
    private final MathTransform2D modelToSceneTransform;

    SynL1CSceneTransformGeoCoding(GeoCoding wrappedGeoCoding, MathTransform2D sceneToModelTransform, MathTransform2D modelToSceneTransform) {
        this.wrappedGeoCoding = wrappedGeoCoding;
        this.setMapCRS(wrappedGeoCoding.getMapCRS());
        this.setGeoCRS(wrappedGeoCoding.getGeoCRS());
        this.sceneToModelTransform = sceneToModelTransform;
        this.modelToSceneTransform = modelToSceneTransform;
        this.setImageCRS((CoordinateReferenceSystem)SynL1CSceneTransformGeoCoding.createImageCRS((CoordinateReferenceSystem)wrappedGeoCoding.getMapCRS(), (MathTransform)new GeoCodingMathTransform((GeoCoding)this)));
    }

    public boolean isCrossingMeridianAt180() {
        return this.wrappedGeoCoding.isCrossingMeridianAt180();
    }

    public boolean canGetPixelPos() {
        return this.sceneToModelTransform != MathTransform2D.NULL && this.wrappedGeoCoding.canGetPixelPos();
    }

    public boolean canGetGeoPos() {
        return this.modelToSceneTransform != MathTransform2D.NULL && this.wrappedGeoCoding.canGetGeoPos();
    }

    public PixelPos getPixelPos(GeoPos geoPos, PixelPos pixelPos) {
        PixelPos wrappedPixelPos = this.wrappedGeoCoding.getPixelPos(geoPos, new PixelPos());
        if (pixelPos == null) {
            pixelPos = new PixelPos();
        }
        try {
            this.sceneToModelTransform.transform((Point2D)wrappedPixelPos, (Point2D)pixelPos);
        }
        catch (TransformException e) {
            pixelPos.setLocation(Double.NaN, Double.NaN);
        }
        return pixelPos;
    }

    public GeoPos getGeoPos(PixelPos pixelPos, GeoPos geoPos) {
        if (geoPos == null) {
            geoPos = new GeoPos();
        }
        try {
            PixelPos modelPixelPos = new PixelPos();
            this.modelToSceneTransform.transform((Point2D)pixelPos, (Point2D)modelPixelPos);
            geoPos = this.wrappedGeoCoding.getGeoPos(modelPixelPos, geoPos);
        }
        catch (TransformException e) {
            geoPos.setLocation(Double.NaN, Double.NaN);
        }
        return geoPos;
    }

    public Datum getDatum() {
        return this.wrappedGeoCoding.getDatum();
    }

    public void dispose() {
    }

    public boolean transferGeoCoding(Scene srcScene, Scene destScene, ProductSubsetDef subsetDef) {
        if (subsetDef != null || srcScene.getProduct() != destScene.getProduct()) {
            return false;
        }
        destScene.setGeoCoding((GeoCoding)new SynL1CSceneTransformGeoCoding(this.wrappedGeoCoding, this.sceneToModelTransform, this.modelToSceneTransform));
        return true;
    }
}

