/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.synergy;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Arrays;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.SceneTransformProvider;
import org.esa.snap.core.transform.AbstractTransform2D;
import org.esa.snap.core.transform.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

class SynL1COlciSceneTransformProvider
implements SceneTransformProvider {
    private final SynL1COlciModelToSceneTransform modelToSceneTransform;
    private final SynL1COlciSceneToModelTransform sceneToModelTransform;

    SynL1COlciSceneTransformProvider(Band columnMisregistrationBand, Band rowMisregistrationBand) {
        this.modelToSceneTransform = new SynL1COlciModelToSceneTransform(columnMisregistrationBand, rowMisregistrationBand);
        this.sceneToModelTransform = new SynL1COlciSceneToModelTransform(columnMisregistrationBand, rowMisregistrationBand);
    }

    public MathTransform2D getModelToSceneTransform() {
        return this.modelToSceneTransform;
    }

    public MathTransform2D getSceneToModelTransform() {
        return this.sceneToModelTransform;
    }

    private class SynL1COlciSceneToModelTransform
    extends AbstractTransform2D {
        private final int[] columnMisregistration;
        private final int[] rowMisregistration;
        private static final int invalid_value = Integer.MIN_VALUE;

        SynL1COlciSceneToModelTransform(Band columnMisregistrationBand, Band rowMisregistrationBand) {
            this.columnMisregistration = this.createMisRegistrationArray(columnMisregistrationBand);
            this.rowMisregistration = this.createMisRegistrationArray(rowMisregistrationBand);
        }

        private int[] createMisRegistrationArray(Band misregistrationBand) {
            int[] misregistrationArray = new int[misregistrationBand.getRasterWidth()];
            Arrays.fill(misregistrationArray, Integer.MIN_VALUE);
            int[] forwardRegistration = new int[misregistrationArray.length];
            try {
                misregistrationBand.readPixels(0, 0, misregistrationBand.getRasterWidth(), misregistrationBand.getRasterHeight(), forwardRegistration);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (int i = 0; i < misregistrationArray.length; ++i) {
                int columnPosition = i + forwardRegistration[i];
                if (columnPosition <= 0 || columnPosition >= misregistrationArray.length) continue;
                misregistrationArray[columnPosition] = -1 * forwardRegistration[i];
            }
            int lastValidValue = Integer.MIN_VALUE;
            for (int i = 0; i < misregistrationArray.length; ++i) {
                int j;
                if (misregistrationArray[i] != Integer.MIN_VALUE || i >= misregistrationArray.length - 1) continue;
                int nextValidValue = Integer.MIN_VALUE;
                int nextValidIndex = Integer.MIN_VALUE;
                for (j = i; j < misregistrationArray.length; ++j) {
                    if (misregistrationArray[j] == Integer.MIN_VALUE) continue;
                    nextValidValue = misregistrationArray[j];
                    nextValidIndex = j;
                    break;
                }
                if (lastValidValue == Integer.MIN_VALUE) {
                    lastValidValue = nextValidValue;
                }
                if (nextValidIndex == Integer.MIN_VALUE) {
                    nextValidIndex = misregistrationArray.length - 1;
                    nextValidValue = lastValidValue;
                }
                for (j = nextValidIndex; j >= i; --j) {
                    misregistrationArray[j] = (int)((double)lastValidValue + (double)(lastValidValue - nextValidValue) * ((double)(nextValidIndex - j) / (double)nextValidIndex - (double)i));
                }
            }
            return misregistrationArray;
        }

        public Point2D transform(Point2D ptSrc, Point2D ptDst) throws TransformException {
            double srcPtX = ptSrc.getX();
            double srcPtY = ptSrc.getY();
            if (Double.isNaN(srcPtX) || Double.isNaN(srcPtY) || srcPtX < 0.0 || srcPtX >= (double)this.columnMisregistration.length) {
                throw new TransformException("Could not transform");
            }
            double x = srcPtX + (double)this.columnMisregistration[(int)srcPtX];
            double y = srcPtY + (double)this.rowMisregistration[(int)srcPtX];
            if (x < 0.0 || y < 0.0) {
                throw new TransformException("Could not transform");
            }
            if (ptDst == null) {
                ptDst = new Point2D.Double();
            }
            ptDst.setLocation(x, y);
            return ptDst;
        }

        public MathTransform2D inverse() throws NoninvertibleTransformException {
            return SynL1COlciSceneTransformProvider.this.modelToSceneTransform;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof SynL1COlciSceneToModelTransform)) {
                return false;
            }
            return this.equalArrays(((SynL1COlciSceneToModelTransform)((Object)object)).columnMisregistration, this.columnMisregistration) && this.equalArrays(((SynL1COlciSceneToModelTransform)((Object)object)).rowMisregistration, this.rowMisregistration);
        }

        private boolean equalArrays(int[] array1, int[] array2) {
            if (array1 == array2) {
                return true;
            }
            if (array1 == null || array2 == null) {
                return false;
            }
            if (array1.length != array2.length) {
                return false;
            }
            for (int i = 0; i < array1.length; ++i) {
                if (array1[i] == array2[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hashCode = 0;
            for (int i = 0; i < this.columnMisregistration.length; ++i) {
                hashCode += this.columnMisregistration[i];
                hashCode += this.rowMisregistration[i];
            }
            return hashCode;
        }
    }

    private class SynL1COlciModelToSceneTransform
    extends AbstractTransform2D {
        private final Band columnMisregistrationBand;
        private final Band rowMisregistrationBand;

        SynL1COlciModelToSceneTransform(Band columnMisregistrationBand, Band rowMisregistrationBand) {
            this.columnMisregistrationBand = columnMisregistrationBand;
            this.rowMisregistrationBand = rowMisregistrationBand;
        }

        public Point2D transform(Point2D ptSrc, Point2D ptDst) throws TransformException {
            double srcPtX = ptSrc.getX();
            double srcPtY = ptSrc.getY();
            if (Double.isNaN(srcPtX) || Double.isNaN(srcPtY) || srcPtX < 0.0 || srcPtX >= (double)this.columnMisregistrationBand.getRasterWidth()) {
                throw new TransformException("Could not transform");
            }
            int columnMisregistration = this.columnMisregistrationBand.getSampleInt((int)srcPtX, 0);
            int rowMisregistration = this.rowMisregistrationBand.getSampleInt((int)srcPtX, 0);
            double x = srcPtX + (double)columnMisregistration;
            double y = srcPtY + (double)rowMisregistration;
            if (x < 0.0 || y < 0.0) {
                throw new TransformException("Could not transform");
            }
            if (ptDst == null) {
                ptDst = new Point2D.Double();
            }
            ptDst.setLocation(x, y);
            return ptDst;
        }

        public MathTransform2D inverse() throws NoninvertibleTransformException {
            return SynL1COlciSceneTransformProvider.this.sceneToModelTransform;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof SynL1COlciModelToSceneTransform)) {
                return false;
            }
            return ((SynL1COlciModelToSceneTransform)((Object)object)).columnMisregistrationBand == this.columnMisregistrationBand && ((SynL1COlciModelToSceneTransform)((Object)object)).rowMisregistrationBand == this.rowMisregistrationBand;
        }

        public int hashCode() {
            return this.columnMisregistrationBand.getName().hashCode() + this.rowMisregistrationBand.getName().hashCode();
        }
    }
}

