/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.synergy;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

class NcFile {
    private final NetcdfFile netcdfFile;

    static NcFile open(File file) throws IOException {
        return new NcFile(NetcdfFile.open((String)file.getPath()));
    }

    static NcFile openResource(String name) throws IOException, URISyntaxException {
        URL url = NcFile.class.getResource(name);
        File file = new File(url.toURI());
        return new NcFile(NetcdfFile.open((String)file.getPath()));
    }

    private NcFile(NetcdfFile netcdfFile) {
        this.netcdfFile = netcdfFile;
    }

    List<Variable> getVariables(String regex) {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        for (Variable variable : this.netcdfFile.getVariables()) {
            if (!variable.getName().matches(regex)) continue;
            variables.add(variable);
        }
        return variables;
    }

    double[] read(String name) throws IOException {
        return this.getDoubles(this.netcdfFile, name);
    }

    void close() {
        try {
            this.netcdfFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private double[] getDoubles(NetcdfFile ncFile, String name) throws IOException {
        Variable variable = ncFile.findVariable(name);
        if (variable != null) {
            double scaleFactor = this.getAttributeDouble(variable, "scale_factor", 1.0);
            double addOffset = this.getAttributeDouble(variable, "add_offset", 0.0);
            double fillValue = this.getAttributeDouble(variable, "_FillValue", Double.NaN);
            Array array = variable.read();
            double[] data = new double[(int)variable.getSize()];
            for (int i = 0; i < data.length; ++i) {
                double value = array.getDouble(i);
                data[i] = Double.isNaN(value) || value == fillValue ? Double.NaN : addOffset + value * scaleFactor;
            }
            return data;
        }
        return null;
    }

    private double getAttributeDouble(Variable variable, String attributeName, double defaultValue) {
        Attribute attribute = variable.findAttribute(attributeName);
        if (attribute == null) {
            return defaultValue;
        }
        return attribute.getNumericValue().doubleValue();
    }
}

