/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.slstr;

import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import com.bc.ceres.glevel.support.DefaultMultiLevelSource;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.s3tbx.dataio.s3.Manifest;
import org.esa.s3tbx.dataio.s3.Sentinel3ProductReader;
import org.esa.s3tbx.dataio.s3.slstr.SlstrProductFactory;
import org.esa.s3tbx.dataio.s3.slstr.SlstrTiePointGeoCoding;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.BasicPixelGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoCodingFactory;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.runtime.Config;
import org.geotools.referencing.operation.transform.AffineTransform2D;

public class SlstrSstProductFactory
extends SlstrProductFactory {
    public static final String SLSTR_L2_SST_USE_PIXELGEOCODINGS = "s3tbx.reader.slstrl2sst.pixelGeoCodings";
    private Map<String, GeoCoding> geoCodingMap = new HashMap<String, GeoCoding>();
    private int nadirStartOffset;
    private int nadirTrackOffset;
    private int obliqueStartOffset;
    private int obliqueTrackOffset;

    public SlstrSstProductFactory(Sentinel3ProductReader productReader) {
        super(productReader);
    }

    @Override
    protected List<String> getFileNames(Manifest manifest) {
        return manifest.getFileNames(new String[0]);
    }

    @Override
    protected void configureTargetNode(Band sourceBand, RasterDataNode targetNode) {
        String sourceBandName = sourceBand.getName();
        if (sourceBand.getProduct().getName().contains("SST")) {
            targetNode.setName(sourceBand.getProduct().getName() + "_" + sourceBandName);
        }
    }

    @Override
    protected Product findMasterProduct() {
        List<Product> productList = this.getOpenProductList();
        Product masterProduct = productList.get(0);
        for (int i = 1; i < productList.size(); ++i) {
            Product product = productList.get(i);
            if (product.getSceneRasterWidth() <= masterProduct.getSceneRasterWidth() || product.getSceneRasterHeight() <= masterProduct.getSceneRasterHeight() || product.getName().contains("flags")) continue;
            masterProduct = product;
        }
        return masterProduct;
    }

    @Override
    protected void processProductSpecificMetadata(MetadataElement metadataElement) {
        MetadataElement slstrInformationElement = metadataElement.getElement("slstrProductInformation");
        for (int i = 0; i < slstrInformationElement.getNumElements(); ++i) {
            MetadataElement slstrElement = slstrInformationElement.getElementAt(i);
            String slstrElementName = slstrElement.getName();
            if (!slstrElementName.endsWith("ImageSize")) continue;
            int startOffset = Integer.parseInt(slstrElement.getAttribute("startOffset").getData().getElemString());
            int trackOffset = Integer.parseInt(slstrElement.getAttribute("trackOffset").getData().getElemString());
            if (slstrElementName.equals("nadirImageSize")) {
                this.nadirStartOffset = startOffset;
                this.nadirTrackOffset = trackOffset;
                this.setReferenceStartOffset(startOffset);
                this.setReferenceTrackOffset(trackOffset);
                this.setReferenceResolutions(this.getResolutions("in"));
                continue;
            }
            this.obliqueStartOffset = startOffset;
            this.obliqueTrackOffset = trackOffset;
        }
    }

    @Override
    protected Integer getStartOffset(String gridIndex) {
        if (gridIndex.endsWith("o")) {
            return this.obliqueStartOffset;
        }
        return this.nadirStartOffset;
    }

    @Override
    protected Integer getTrackOffset(String gridIndex) {
        if (gridIndex.endsWith("o")) {
            return this.obliqueTrackOffset;
        }
        return this.nadirTrackOffset;
    }

    @Override
    protected RasterDataNode addSpecialNode(Product masterProduct, Band sourceBand, Product targetProduct) {
        MetadataElement attributesElement;
        String sourceBandName = sourceBand.getName();
        String sourceProductName = sourceBand.getProduct().getName();
        String gridIndex = sourceProductName.substring(sourceProductName.length() - 2);
        Integer sourceStartOffset = this.getStartOffset(gridIndex);
        Integer sourceTrackOffset = this.getTrackOffset(gridIndex);
        short[] sourceResolutions = this.getResolutions(gridIndex);
        if (gridIndex.startsWith("t") && (attributesElement = sourceBand.getProduct().getMetadataRoot().getElement("Global_Attributes")) != null) {
            MetadataAttribute trackOffsetAttribute;
            MetadataAttribute startOffsetAttribute = attributesElement.getAttribute("start_offset");
            if (startOffsetAttribute != null) {
                sourceStartOffset = startOffsetAttribute.getData().getElemInt();
            }
            if ((trackOffsetAttribute = attributesElement.getAttribute("track_offset")) != null) {
                sourceTrackOffset = trackOffsetAttribute.getData().getElemInt();
            }
        }
        if (sourceStartOffset == null || sourceTrackOffset == null) {
            return sourceBand;
        }
        if (gridIndex.startsWith("t")) {
            return this.copyTiePointGrid(sourceBand, targetProduct, sourceStartOffset.intValue(), sourceTrackOffset.intValue(), sourceResolutions);
        }
        Band targetBand = new Band(sourceBandName, sourceBand.getDataType(), sourceBand.getRasterWidth(), sourceBand.getRasterHeight());
        targetProduct.addBand(targetBand);
        ProductUtils.copyRasterDataNodeProperties((RasterDataNode)sourceBand, (RasterDataNode)targetBand);
        RenderedImage sourceRenderedImage = sourceBand.getSourceImage().getImage(0);
        AffineTransform imageToModelTransform = new AffineTransform();
        float[] offsets = this.getOffsets(sourceStartOffset.intValue(), sourceTrackOffset.intValue(), sourceResolutions);
        imageToModelTransform.translate(offsets[0], offsets[1]);
        short[] referenceResolutions = this.getReferenceResolutions();
        int subSamplingX = sourceResolutions[0] / referenceResolutions[0];
        int subSamplingY = sourceResolutions[1] / referenceResolutions[1];
        imageToModelTransform.scale(subSamplingX, subSamplingY);
        DefaultMultiLevelModel targetModel = new DefaultMultiLevelModel(imageToModelTransform, sourceRenderedImage.getWidth(), sourceRenderedImage.getHeight());
        DefaultMultiLevelSource targetMultiLevelSource = new DefaultMultiLevelSource(sourceRenderedImage, (MultiLevelModel)targetModel);
        targetBand.setSourceImage((MultiLevelImage)new DefaultMultiLevelImage((MultiLevelSource)targetMultiLevelSource));
        return targetBand;
    }

    @Override
    protected void setBandGeoCodings(Product product) throws IOException {
        if (Config.instance((String)"s3tbx").load().preferences().getBoolean(SLSTR_L2_SST_USE_PIXELGEOCODINGS, false)) {
            this.setPixelBandGeoCodings(product);
        } else {
            this.setTiePointBandGeoCodings(product);
        }
    }

    private void setTiePointBandGeoCodings(Product product) throws IOException {
        Band[] bands;
        for (Band band : bands = product.getBands()) {
            this.setTiePointBandGeoCoding(product, band, this.getIdentifier(band.getName()));
        }
        ProductNodeGroup maskGroup = product.getMaskGroup();
        for (int i = 0; i < maskGroup.getNodeCount(); ++i) {
            Mask mask = (Mask)maskGroup.get(i);
            this.setTiePointBandGeoCoding(product, (Band)mask, this.getGridIndexFromMask(mask));
        }
    }

    private void setTiePointBandGeoCoding(Product product, Band band, String gridIndex) throws IOException {
        if (this.geoCodingMap.containsKey(gridIndex)) {
            band.setGeoCoding(this.geoCodingMap.get(gridIndex));
        } else {
            TiePointGrid origLatGrid = product.getTiePointGrid("latitude_tx");
            TiePointGrid origLonGrid = product.getTiePointGrid("longitude_tx");
            if (origLatGrid == null || origLonGrid == null) {
                return;
            }
            short[] referenceResolutions = this.getReferenceResolutions();
            short[] sourceResolutions = this.getResolutions(gridIndex);
            Integer sourceStartOffset = this.getStartOffset(gridIndex);
            Integer sourceTrackOffset = this.getTrackOffset(gridIndex);
            if (sourceStartOffset != null && sourceTrackOffset != null) {
                float[] offsets = this.getOffsets(sourceStartOffset.intValue(), sourceTrackOffset.intValue(), sourceResolutions);
                float[] scalings = new float[]{(float)sourceResolutions[0] / (float)referenceResolutions[0], (float)sourceResolutions[1] / (float)referenceResolutions[1]};
                AffineTransform transform = new AffineTransform();
                transform.translate(offsets[0], offsets[1]);
                transform.scale(scalings[0], scalings[1]);
                try {
                    SlstrTiePointGeoCoding geoCoding = new SlstrTiePointGeoCoding(origLatGrid, origLonGrid, new AffineTransform2D(transform));
                    band.setGeoCoding((GeoCoding)geoCoding);
                    this.geoCodingMap.put(gridIndex, (GeoCoding)geoCoding);
                }
                catch (NoninvertibleTransformException e) {
                    throw new IOException("Could not create band-specific tie-point geo-coding. Try per-pixel geo-codings.");
                }
            }
        }
    }

    private void setPixelBandGeoCodings(Product product) {
        Band[] bands;
        for (Band band : bands = product.getBands()) {
            GeoCoding bandGeoCoding = this.getBandGeoCoding(product, this.getIdentifier(band.getName()));
            band.setGeoCoding(bandGeoCoding);
        }
        ProductNodeGroup maskGroup = product.getMaskGroup();
        for (int i = 0; i < maskGroup.getNodeCount(); ++i) {
            Mask mask = (Mask)maskGroup.get(i);
            GeoCoding bandGeoCoding = this.getBandGeoCoding(product, this.getIdentifier(mask.getName()));
            mask.setGeoCoding(bandGeoCoding);
        }
    }

    private String getIdentifier(String bandName) {
        String[] identifierCandidates = bandName.split("_");
        for (int i = identifierCandidates.length - 1; i >= 0; --i) {
            if (!identifierCandidates[i].equals("io") && !identifierCandidates[i].equals("in")) continue;
            return identifierCandidates[i];
        }
        return "";
    }

    private GeoCoding getBandGeoCoding(Product product, String end) {
        if (this.geoCodingMap.containsKey(end)) {
            return this.geoCodingMap.get(end);
        }
        Band latBand = null;
        Band lonBand = null;
        switch (end) {
            case "in": {
                latBand = product.getBand("latitude_in");
                lonBand = product.getBand("longitude_in");
                break;
            }
            case "io": {
                latBand = product.getBand("latitude_io");
                lonBand = product.getBand("longitude_io");
            }
        }
        if (latBand != null && lonBand != null) {
            BasicPixelGeoCoding geoCoding = GeoCodingFactory.createPixelGeoCoding((Band)latBand, (Band)lonBand, (String)"", (int)5);
            this.geoCodingMap.put(end, (GeoCoding)geoCoding);
            return geoCoding;
        }
        return null;
    }

    private String getGridIndexFromMask(Mask mask) {
        String maskName = mask.getName();
        if (maskName.contains("_in_")) {
            return "in";
        }
        if (maskName.contains("_io_")) {
            return "io";
        }
        return "";
    }
}

