/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.slstr;

import java.io.File;
import java.io.IOException;
import org.esa.s3tbx.dataio.s3.slstr.MetTxReader;
import org.esa.s3tbx.dataio.s3.slstr.SlstrFRPReader;
import org.esa.s3tbx.dataio.s3.slstr.SlstrL2WSTL2PReader;
import org.esa.s3tbx.dataio.s3.slstr.SlstrLSTAncillaryDsReader;
import org.esa.s3tbx.dataio.s3.util.S3NetcdfReader;

public class SlstrNetcdfReaderFactory {
    static S3NetcdfReader createSlstrNetcdfReader(File file) throws IOException {
        String fileName = file.getName();
        if (fileName.equals("FRP_in.nc")) {
            return new SlstrFRPReader(file.getAbsolutePath());
        }
        if (fileName.equals("L2P.nc")) {
            return new SlstrL2WSTL2PReader(file.getAbsolutePath());
        }
        if (fileName.equals("LST_ancillary_ds.nc")) {
            return new SlstrLSTAncillaryDsReader(file.getAbsolutePath());
        }
        if (fileName.equals("met_tx.nc")) {
            return new MetTxReader(file.getAbsolutePath());
        }
        return new S3NetcdfReader(file.getAbsolutePath());
    }
}

