/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.slstr;

import java.awt.image.RenderedImage;
import java.util.List;
import org.esa.s3tbx.dataio.s3.Sentinel3ProductReader;
import org.esa.s3tbx.dataio.s3.slstr.SlstrLevel1ProductFactory;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.ProductUtils;

public class SlstrLevel1B500mProductFactory
extends SlstrLevel1ProductFactory {
    public SlstrLevel1B500mProductFactory(Sentinel3ProductReader productReader) {
        super(productReader);
    }

    @Override
    protected Product findMasterProduct() {
        List<Product> productList = this.getOpenProductList();
        Product masterProduct = new Product("dummy", "type", 1, 1);
        for (Product product : productList) {
            if (product.getSceneRasterWidth() <= masterProduct.getSceneRasterWidth() || product.getSceneRasterHeight() <= masterProduct.getSceneRasterHeight() || product.getName().contains("flags") || product.getName().endsWith("in") || product.getName().endsWith("io")) continue;
            masterProduct = product;
        }
        return masterProduct;
    }

    @Override
    protected RasterDataNode addSpecialNode(Product masterProduct, Band sourceBand, Product targetProduct) {
        String sourceBandName = sourceBand.getName();
        int sourceBandNameLength = sourceBandName.length();
        String gridIndex = sourceBandName;
        if (sourceBandNameLength > 1) {
            gridIndex = sourceBandName.substring(sourceBandNameLength - 2);
        }
        Integer sourceStartOffset = this.getStartOffset(gridIndex);
        Integer sourceTrackOffset = this.getTrackOffset(gridIndex);
        if (sourceStartOffset != null && sourceTrackOffset != null) {
            short[] sourceResolutions = this.getResolutions(gridIndex);
            if (gridIndex.startsWith("t")) {
                return this.copyTiePointGrid(sourceBand, targetProduct, sourceStartOffset.intValue(), sourceTrackOffset.intValue(), sourceResolutions);
            }
            Band targetBand = new Band(sourceBandName, sourceBand.getDataType(), targetProduct.getSceneRasterWidth(), targetProduct.getSceneRasterHeight());
            targetProduct.addBand(targetBand);
            ProductUtils.copyRasterDataNodeProperties((RasterDataNode)sourceBand, (RasterDataNode)targetBand);
            float[] offsets = this.getOffsets(sourceStartOffset.intValue(), sourceTrackOffset.intValue(), sourceResolutions);
            RenderedImage sourceImage = this.createSourceImage(masterProduct, sourceBand, offsets, targetBand, sourceResolutions);
            targetBand.setSourceImage(sourceImage);
            return targetBand;
        }
        return sourceBand;
    }

    @Override
    protected void configureDescription(Band sourceBand, RasterDataNode targetNode) {
    }

    @Override
    protected void changeTargetProductName(Product targetProduct) {
        targetProduct.setName(targetProduct.getName() + "_500m");
    }

    @Override
    protected void setSceneTransforms(Product product) {
    }

    @Override
    protected void setBandGeoCodings(Product product) {
    }
}

