/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.slstr;

import java.io.IOException;
import org.esa.s3tbx.dataio.s3.util.S3NetcdfReader;
import org.esa.snap.core.datamodel.Product;
import ucar.nc2.Variable;

class MetTxReader
extends S3NetcdfReader {
    MetTxReader(String pathToFile) throws IOException {
        super(pathToFile);
    }

    @Override
    protected String[] getSeparatingDimensions() {
        return new String[]{"n_bound", "t_series", "p_atmos"};
    }

    @Override
    public String[] getSuffixesForSeparatingDimensions() {
        return new String[]{"bound", "time", "pressure_level"};
    }

    @Override
    protected void addVariableAsBand(Product product, Variable variable, String variableName, boolean synthetic) {
        String[] suffixesForSeparatingDimensions;
        for (String suffixForSeparatingDimension : suffixesForSeparatingDimensions = this.getSuffixesForSeparatingDimensions()) {
            if (!variableName.contains(suffixForSeparatingDimension)) continue;
            variableName = variableName + "_tx";
            break;
        }
        super.addVariableAsBand(product, variable, variableName, synthetic);
    }

    @Override
    protected int getDimensionIndexFromBandName(String bandName) {
        int end = bandName.lastIndexOf("_");
        int start = bandName.substring(0, end).lastIndexOf("_");
        return Integer.parseInt(bandName.substring(start + 1, end)) - 1;
    }
}

