/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.olci;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.esa.s3tbx.dataio.s3.AbstractProductFactory;
import org.esa.s3tbx.dataio.s3.Manifest;
import org.esa.s3tbx.dataio.s3.Sentinel3ProductReader;
import org.esa.s3tbx.dataio.s3.util.S3NetcdfReader;
import org.esa.s3tbx.dataio.s3.util.S3NetcdfReaderFactory;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoCodingFactory;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RGBImageProfile;
import org.esa.snap.core.datamodel.RGBImageProfileManager;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.runtime.Config;

public abstract class OlciProductFactory
extends AbstractProductFactory {
    private static final String[] excludedIDs = new String[]{"removedPixelsData"};
    private Map<String, Float> nameToWavelengthMap = new HashMap<String, Float>();
    private Map<String, Float> nameToBandwidthMap = new HashMap<String, Float>();
    private Map<String, Integer> nameToIndexMap = new HashMap<String, Integer>();
    private int subSamplingX;
    private int subSamplingY;
    public static final String OLCI_USE_PIXELGEOCODING = "s3tbx.reader.olci.pixelGeoCoding";

    public OlciProductFactory(Sentinel3ProductReader productReader) {
        super(productReader);
        OlciProductFactory.registerRGBProfiles();
    }

    @Override
    protected List<String> getFileNames(Manifest manifest) {
        return manifest.getFileNames(excludedIDs);
    }

    @Override
    protected void processProductSpecificMetadata(MetadataElement metadataElement) {
        MetadataElement olciInformationElement = metadataElement.getElement("olciProductInformation");
        MetadataElement samplingParametersElement = olciInformationElement.getElement("samplingParameters");
        this.subSamplingY = Integer.parseInt(samplingParametersElement.getAttribute("rowsPerTiePoint").getData().toString());
        this.subSamplingX = Integer.parseInt(samplingParametersElement.getAttribute("columnsPerTiePoint").getData().toString());
        MetadataElement bandDescriptionsElement = olciInformationElement.getElement("bandDescriptions");
        if (bandDescriptionsElement != null) {
            for (int i = 0; i < bandDescriptionsElement.getNumElements(); ++i) {
                MetadataElement bandDescriptionElement = bandDescriptionsElement.getElementAt(i);
                String bandName = bandDescriptionElement.getAttribute("name").getData().getElemString();
                float wavelength = Float.parseFloat(bandDescriptionElement.getAttribute("centralWavelength").getData().getElemString());
                float bandWidth = Float.parseFloat(bandDescriptionElement.getAttribute("bandWidth").getData().getElemString());
                this.nameToWavelengthMap.put(bandName, Float.valueOf(wavelength));
                this.nameToBandwidthMap.put(bandName, Float.valueOf(bandWidth));
                this.nameToIndexMap.put(bandName, i);
            }
        }
    }

    private float getWavelength(String name) {
        return this.nameToWavelengthMap.get(name).floatValue();
    }

    private float getBandwidth(String name) {
        return this.nameToBandwidthMap.get(name).floatValue();
    }

    private int getBandindex(String name) {
        return this.nameToIndexMap.get(name);
    }

    @Override
    protected RasterDataNode addSpecialNode(Product masterProduct, Band sourceBand, Product targetProduct) {
        String sourceBandName = sourceBand.getName();
        if (targetProduct.containsBand(sourceBandName)) {
            sourceBand.setName("TP_" + sourceBandName);
        }
        return OlciProductFactory.copyBandAsTiePointGrid(sourceBand, targetProduct, this.subSamplingX, this.subSamplingY, 0.0f, 0.0f);
    }

    @Override
    protected void setGeoCoding(Product targetProduct) throws IOException {
        if (Config.instance((String)"s3tbx").load().preferences().getBoolean(OLCI_USE_PIXELGEOCODING, false)) {
            this.setPixelGeoCoding(targetProduct);
        } else {
            this.setTiePointGeoCoding(targetProduct);
        }
    }

    private void setPixelGeoCoding(Product targetProduct) {
        Band latBand = targetProduct.getBand("latitude");
        Band lonBand = targetProduct.getBand("longitude");
        if (latBand != null && lonBand != null) {
            targetProduct.setSceneGeoCoding((GeoCoding)GeoCodingFactory.createPixelGeoCoding((Band)latBand, (Band)lonBand, (String)this.getValidExpression(), (int)5));
        }
    }

    private void setTiePointGeoCoding(Product targetProduct) {
        if (targetProduct.getSceneGeoCoding() == null && targetProduct.getTiePointGrid("latitude") != null && targetProduct.getTiePointGrid("longitude") != null) {
            targetProduct.setSceneGeoCoding((GeoCoding)new TiePointGeoCoding(targetProduct.getTiePointGrid("latitude"), targetProduct.getTiePointGrid("longitude")));
        }
        if (targetProduct.getSceneGeoCoding() == null && targetProduct.getTiePointGrid("TP_latitude") != null && targetProduct.getTiePointGrid("TP_longitude") != null) {
            targetProduct.setSceneGeoCoding((GeoCoding)new TiePointGeoCoding(targetProduct.getTiePointGrid("TP_latitude"), targetProduct.getTiePointGrid("TP_longitude")));
        }
    }

    @Override
    protected void configureTargetNode(Band sourceBand, RasterDataNode targetNode) {
        Band targetBand;
        if (targetNode.getName().matches("Oa[0-2][0-9].*") && targetNode instanceof Band) {
            targetBand = (Band)targetNode;
            String cutName = targetBand.getName().substring(0, 4);
            targetBand.setSpectralBandIndex(this.getBandindex(cutName));
            targetBand.setSpectralWavelength(this.getWavelength(cutName));
            targetBand.setSpectralBandwidth(this.getBandwidth(cutName));
        }
        if ((targetNode.getName().startsWith("ADG443_NN") || targetNode.getName().startsWith("CHL_NN") || targetNode.getName().startsWith("CHL_OC4ME") || targetNode.getName().startsWith("KD490_M07") || targetNode.getName().startsWith("TSM_NN")) && targetNode instanceof Band) {
            targetBand = (Band)targetNode;
            String unit = targetBand.getUnit();
            Pattern pattern = Pattern.compile("lg\\s*\\(\\s*re:?\\s*(.*)\\)");
            Matcher m = pattern.matcher(unit);
            if (m.matches()) {
                targetBand.setLog10Scaled(true);
                targetBand.setUnit(m.group(1));
                String description = targetBand.getDescription();
                description = description.replace("log10 scaled ", "");
                targetBand.setDescription(description);
            } else {
                this.getLogger().log(Level.WARNING, "Unit extraction not working for band " + targetNode.getName());
            }
            targetNode.setValidPixelExpression(this.getValidExpression());
        }
    }

    protected abstract String getValidExpression();

    @Override
    protected Product readProduct(String fileName) throws IOException {
        File file = new File(this.getInputFileParentDirectory(), fileName);
        if (!file.exists()) {
            return null;
        }
        S3NetcdfReader reader = S3NetcdfReaderFactory.createS3NetcdfReader(file);
        this.addSeparatingDimensions(reader.getSuffixesForSeparatingDimensions());
        return reader.readProduct();
    }

    private static void registerRGBProfiles() {
        RGBImageProfileManager manager = RGBImageProfileManager.getInstance();
        manager.addProfile(new RGBImageProfile("OLCI L1 - Tristimulus", new String[]{"log(1.0 + 0.01 * Oa01_radiance + 0.09 * Oa02_radiance + 0.35 * Oa03_radiance + 0.04 * Oa04_radiance + 0.01 * Oa05_radiance + 0.59 * Oa06_radiance + 0.85 * Oa07_radiance + 0.12 * Oa08_radiance + 0.07 * Oa09_radiance + 0.04 * Oa10_radiance)", "log(1.0 + 0.26 * Oa03_radiance + 0.21 * Oa04_radiance + 0.50 * Oa05_radiance + Oa06_radiance + 0.38 * Oa07_radiance + 0.04 * Oa08_radiance + 0.03 * Oa09_radiance + 0.02 * Oa10_radiance)", "log(1.0 + 0.07 * Oa01_radiance + 0.28 * Oa02_radiance + 1.77 * Oa03_radiance + 0.47 * Oa04_radiance + 0.16 * Oa05_radiance)"}, new String[]{"S3*_OL_1*", "S3*_OL_1*", ""}));
        manager.addProfile(new RGBImageProfile("OLCI L2 W - Tristimulus", new String[]{"log(0.05 + 0.01 * Oa01_reflectance + 0.09 * Oa02_reflectance + 0.35 * Oa03_reflectance + 0.04 * Oa04_reflectance + 0.01 * Oa05_reflectance + 0.59 * Oa06_reflectance + 0.85 * Oa07_reflectance + 0.12 * Oa08_reflectance + 0.07 * Oa09_reflectance + 0.04 * Oa10_reflectance)", "log(0.05 + 0.26 * Oa03_reflectance + 0.21 * Oa04_reflectance + 0.50 * Oa05_reflectance + Oa06_reflectance + 0.38 * Oa07_reflectance + 0.04 * Oa08_reflectance + 0.03 * Oa09_reflectance + 0.02 * Oa10_reflectance)", "log(0.05 + 0.07 * Oa01_reflectance + 0.28 * Oa02_reflectance + 1.77 * Oa03_reflectance + 0.47 * Oa04_reflectance + 0.16 * Oa05_reflectance)"}, new String[]{"S3*OL_2_W*", "S3*OL_2_W*", ""}));
        manager.addProfile(new RGBImageProfile("OLCI L1 - 17,6,3", new String[]{"Oa17_radiance", "Oa06_radiance", "Oa03_radiance"}));
        manager.addProfile(new RGBImageProfile("OLCI L1 - 17,5,2", new String[]{"Oa17_radiance", "Oa05_radiance", "Oa02_radiance"}));
        manager.addProfile(new RGBImageProfile("OLCI L2W - 17,6,3", new String[]{"Oa17_reflectance", "Oa06_reflectance", "Oa03_reflectance"}));
        manager.addProfile(new RGBImageProfile("OLCI L2W - 17,5,2", new String[]{"Oa17_reflectance", "Oa05_reflectance", "Oa02_reflectance"}));
    }
}

