/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.olci;

import org.esa.s3tbx.dataio.s3.Sentinel3ProductReader;
import org.esa.s3tbx.dataio.s3.olci.OlciProductFactory;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNodeGroup;

public class OlciLevel1ProductFactory
extends OlciProductFactory {
    private static final String validExpression = "!quality_flags.invalid";

    public OlciLevel1ProductFactory(Sentinel3ProductReader productReader) {
        super(productReader);
    }

    @Override
    protected void setAutoGrouping(Product[] sourceProducts, Product targetProduct) {
        targetProduct.setAutoGrouping("Oa*_radiance:Oa*_radiance_err:atmospheric_temperature_profile:lambda0:FWHM:solar_flux");
    }

    @Override
    protected String getValidExpression() {
        return validExpression;
    }

    @Override
    protected ProductNodeGroup<Mask> prepareMasksForCopying(ProductNodeGroup<Mask> maskGroup) {
        for (int i = 0; i < maskGroup.getNodeCount(); ++i) {
            Mask mask = (Mask)maskGroup.get(i);
            if (mask.getName().equals("quality_flags_invalid")) {
                mask.setName("quality_flags_cosmetic");
                continue;
            }
            if (mask.getName().equals("quality_flags_cosmetic")) {
                mask.setName("quality_flags_invalid");
                continue;
            }
            if (mask.getName().equals("quality_flags_duplicated")) {
                mask.setName("quality_flags_sun_glint_risk");
                continue;
            }
            if (!mask.getName().equals("quality_flags_sun_glint_risk")) continue;
            mask.setName("quality_flags_duplicated");
        }
        return maskGroup;
    }
}

