/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathFactory;
import org.esa.s3tbx.dataio.s3.Manifest;
import org.esa.s3tbx.dataio.util.XPathHelper;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.ArrayUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XfduManifest
implements Manifest {
    private final Document doc;
    private final XPathHelper xPathHelper;

    public static Manifest createManifest(Document manifestDocument) {
        return new XfduManifest(manifestDocument);
    }

    private XfduManifest(Document manifestDocument) {
        this.doc = manifestDocument;
        this.xPathHelper = new XPathHelper(XPathFactory.newInstance().newXPath());
    }

    @Override
    public String getDescription() {
        return this.xPathHelper.getString("/XFDU/informationPackageMap/contentUnit/@textInfo", this.doc);
    }

    @Override
    public ProductData.UTC getStartTime() {
        return this.getTime("startTime");
    }

    @Override
    public ProductData.UTC getStopTime() {
        return this.getTime("stopTime");
    }

    @Override
    public List<String> getFileNames(String schema) {
        ArrayList<String> fileNameList = new ArrayList<String>();
        this.getFileNames("dataObjectSection/dataObject", fileNameList);
        this.getFileNames("metadataSection/metadataObject", fileNameList);
        return fileNameList;
    }

    @Override
    public List<String> getFileNames(String[] excluded) {
        ArrayList<String> fileNameList = new ArrayList<String>();
        NodeList nodeList = this.xPathHelper.getNodeList("/XFDU/dataObjectSection/dataObject", this.doc);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String fileName;
            String id;
            Node item = nodeList.item(i);
            NamedNodeMap attributes = item.getAttributes();
            if (attributes == null) continue;
            Attr attr = (Attr)attributes.getNamedItem("ID");
            String string = id = attr == null ? "" : attr.getValue();
            if (ArrayUtils.isMemberOf((Object)id, (Object[])excluded) || fileNameList.contains(fileName = this.xPathHelper.getString("./byteStream/fileLocation/@href", item))) continue;
            fileNameList.add(fileName);
        }
        return fileNameList;
    }

    @Override
    public MetadataElement getMetadata() {
        MetadataElement manifestElement = new MetadataElement("Manifest");
        Node node = this.xPathHelper.getNode("//metadataSection", this.doc);
        manifestElement.addElement(this.convertNodeToMetadataElement(node, new MetadataElement(node.getNodeName())));
        return manifestElement;
    }

    private static String removeNamespace(String withNamespace) {
        if (!withNamespace.contains(":")) {
            return withNamespace;
        }
        return withNamespace.split(":")[1];
    }

    private MetadataElement convertNodeToMetadataElement(Node rootNode, MetadataElement rootMetadata) {
        NodeList childNodes = rootNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().contains(":")) {
                Object textContent;
                MetadataElement element;
                String nodeName = XfduManifest.removeNamespace(node.getNodeName());
                if (XfduManifest.hasElementChildNodes(node)) {
                    element = new MetadataElement(nodeName);
                    rootMetadata.addElement(element);
                    this.addAttributesToElement(node, element);
                    this.convertNodeToMetadataElement(node, element);
                    continue;
                }
                if (XfduManifest.hasAttributeChildNodes(node)) {
                    element = new MetadataElement(nodeName);
                    rootMetadata.addElement(element);
                    textContent = node.getTextContent().trim();
                    if (!((String)textContent).equals("")) {
                        element.setAttributeString(nodeName, (String)textContent);
                    }
                    this.addAttributesToElement(node, element);
                    continue;
                }
                String nodevalue = node.getTextContent().trim();
                textContent = ProductData.createInstance((String)nodevalue);
                rootMetadata.addAttribute(new MetadataAttribute(nodeName, (ProductData)textContent, true));
                continue;
            }
            this.convertNodeToMetadataElement(node, rootMetadata);
        }
        return rootMetadata;
    }

    private void addAttributesToElement(Node node, MetadataElement element) {
        NamedNodeMap attributes = node.getAttributes();
        for (int j = 0; j < attributes.getLength(); ++j) {
            Node nodeAttribute = attributes.item(j);
            String nodeAttributeValue = nodeAttribute.getTextContent();
            ProductData attributeTextContent = ProductData.createInstance((String)nodeAttributeValue);
            String attributeNodeName = XfduManifest.removeNamespace(nodeAttribute.getNodeName());
            MetadataAttribute attribute = new MetadataAttribute(attributeNodeName, attributeTextContent, true);
            element.addAttribute(attribute);
        }
    }

    private static boolean hasElementChildNodes(Node rootNode) {
        NodeList childNodes = rootNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    private static boolean hasAttributeChildNodes(Node rootNode) {
        NamedNodeMap attributeNodes = rootNode.getAttributes();
        for (int i = 0; i < attributeNodes.getLength(); ++i) {
            Node node = attributeNodes.item(i);
            if (node.getNodeType() != 2) continue;
            return true;
        }
        return false;
    }

    private List<String> getFileNames(String objectPath, List<String> fileNameList) {
        NodeList nodeList = this.xPathHelper.getNodeList("/XFDU/" + objectPath, this.doc);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node item = nodeList.item(i);
            String fileName = this.xPathHelper.getString("./byteStream/fileLocation/@href", item);
            if (fileNameList.contains(fileName)) continue;
            fileNameList.add(fileName);
        }
        return fileNameList;
    }

    private ProductData.UTC getTime(String name) {
        Node period = this.xPathHelper.getNode("/XFDU/metadataSection/metadataObject[@ID='acquisitionPeriod']", this.doc);
        String time = this.xPathHelper.getString("//metadataWrap/xmlData/acquisitionPeriod/" + name, period);
        try {
            if (!Character.isDigit(time.charAt(time.length() - 1))) {
                time = time.substring(0, time.length() - 1);
            }
            return ProductData.UTC.parse((String)time, (String)"yyyy-MM-dd'T'HH:mm:ss");
        }
        catch (ParseException ignored) {
            return null;
        }
    }
}

