/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import org.esa.s3tbx.dataio.s3.ProductFactory;
import org.esa.s3tbx.dataio.s3.olci.OlciLevel1ProductFactory;
import org.esa.s3tbx.dataio.s3.olci.OlciLevel2LProductFactory;
import org.esa.s3tbx.dataio.s3.olci.OlciLevel2WProductFactory;
import org.esa.s3tbx.dataio.s3.slstr.SlstrLevel1B1kmProductFactory;
import org.esa.s3tbx.dataio.s3.slstr.SlstrLevel1B1kmProductReaderPlugIn;
import org.esa.s3tbx.dataio.s3.slstr.SlstrLevel1B500mProductFactory;
import org.esa.s3tbx.dataio.s3.slstr.SlstrLevel1B500mProductReaderPlugIn;
import org.esa.s3tbx.dataio.s3.slstr.SlstrLevel1ProductFactory;
import org.esa.s3tbx.dataio.s3.slstr.SlstrLstProductFactory;
import org.esa.s3tbx.dataio.s3.slstr.SlstrSstProductFactory;
import org.esa.s3tbx.dataio.s3.slstr.SlstrWstProductFactory;
import org.esa.s3tbx.dataio.s3.synergy.SynL1CProductFactory;
import org.esa.s3tbx.dataio.s3.synergy.SynLevel2ProductFactory;
import org.esa.s3tbx.dataio.s3.synergy.VgtProductFactory;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;

public class Sentinel3ProductReader
extends AbstractProductReader {
    private ProductFactory factory;

    public Sentinel3ProductReader(ProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
    }

    protected Product readProductNodesImpl() throws IOException {
        String dirName = this.getInputFileParentDirectory().getName();
        if (dirName.matches("S3.?_OL_1_E[RF]R_.*.SEN3")) {
            this.setFactory(new OlciLevel1ProductFactory(this));
        } else if (dirName.matches("S3.?_OL_2_(L[FR]R)_.*.SEN3")) {
            this.setFactory(new OlciLevel2LProductFactory(this));
        } else if (dirName.matches("S3.?_OL_2_(W[FR]R)_.*.SEN3")) {
            this.setFactory(new OlciLevel2WProductFactory(this));
        } else if (dirName.matches("S3.?_SL_1_RBT.*")) {
            ProductReaderPlugIn readerPlugIn = this.getReaderPlugIn();
            if (readerPlugIn instanceof SlstrLevel1B1kmProductReaderPlugIn) {
                this.setFactory(new SlstrLevel1B1kmProductFactory(this));
            } else if (readerPlugIn instanceof SlstrLevel1B500mProductReaderPlugIn) {
                this.setFactory(new SlstrLevel1B500mProductFactory(this));
            } else {
                this.setFactory(new SlstrLevel1ProductFactory(this));
            }
        } else if (dirName.matches("S3.?_SL_2_LST_.*.SEN3")) {
            this.setFactory(new SlstrLstProductFactory(this));
        } else if (dirName.matches("S3.?_SL_2_WST_.*.SEN3")) {
            this.setFactory(new SlstrWstProductFactory(this));
        } else if (dirName.matches("S3.?_SL_2_WCT_.*.SEN3")) {
            this.setFactory(new SlstrSstProductFactory(this));
        } else if (dirName.matches("S3.?_SY_1_SYN_.*")) {
            this.setFactory(new SynL1CProductFactory(this));
        } else if (dirName.matches("S3.?_SY_2_SYN_.*.SEN3")) {
            this.setFactory(new SynLevel2ProductFactory(this));
        } else if (dirName.matches("S3.?_SY_(2_VGP|[23]_VG1)_.*.SEN3")) {
            this.setFactory(new VgtProductFactory(this));
        }
        return this.createProduct();
    }

    protected void setFactory(ProductFactory factory) {
        this.factory = factory;
    }

    protected Product createProduct() throws IOException {
        if (this.factory == null) {
            throw new IOException("Cannot read product file '" + this.getInputFile() + "'.");
        }
        return this.factory.createProduct();
    }

    protected void setInput(Object input) {
        if (input instanceof File && ((File)input).isDirectory()) {
            super.setInput((Object)new File((File)input, "xfdumanifest.xml"));
        } else {
            super.setInput(input);
        }
    }

    protected final void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        throw new IllegalStateException("Data are provided by images.");
    }

    public final void close() throws IOException {
        this.factory.dispose();
        super.close();
    }

    public final File getInputFile() {
        return new File(this.getInput().toString());
    }

    public final File getInputFileParentDirectory() {
        return this.getInputFile().getParentFile();
    }
}

