/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.util;

import java.io.IOException;
import junit.framework.TestCase;
import org.esa.s3tbx.dataio.s3.util.S3NetcdfReader;
import org.esa.snap.core.datamodel.Product;
import org.junit.Before;
import org.junit.Test;

public class S3NetcdfReaderTest {
    private S3NetcdfReader reader;

    @Before
    public void setUp() throws IOException {
        String netDCFFilePath = S3NetcdfReader.class.getResource("../../s3/FRP_in.nc").getPath();
        this.reader = new S3NetcdfReader(netDCFFilePath);
    }

    @Test
    public void testReadProductType() throws IOException {
        String productType = this.reader.readProductType();
        TestCase.assertEquals((String)"NetCDF", (String)productType);
    }

    @Test
    public void testGetWidth() throws IOException {
        int width = this.reader.getWidth();
        TestCase.assertEquals((int)1568, (int)width);
    }

    @Test
    public void testGetHeight() throws IOException {
        int height = this.reader.getHeight();
        TestCase.assertEquals((int)266, (int)height);
    }

    @Test
    public void testReadProduct() throws Exception {
        Product product = this.reader.readProduct();
        TestCase.assertNotNull((Object)product);
        TestCase.assertEquals((String)"FRP_in", (String)product.getName());
        TestCase.assertEquals((String)"NetCDF", (String)product.getProductType());
        TestCase.assertEquals((int)1568, (int)product.getSceneRasterWidth());
        TestCase.assertEquals((int)266, (int)product.getSceneRasterHeight());
    }
}

