/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.synergy;

import java.awt.geom.Point2D;
import junit.framework.TestCase;
import org.esa.s3tbx.dataio.s3.synergy.SynL1COlciSceneTransformProvider;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.transform.MathTransform2D;
import org.junit.Before;
import org.junit.Test;

public class SynL1COlciSceneTransformProviderTest {
    private SynL1COlciSceneTransformProvider provider;

    @Before
    public void setUp() {
        Band colMisregistrationBand = new Band("colMisregistrationBand", 12, 16, 1);
        ProductData colMisRegistrationData = ProductData.createInstance((int[])new int[]{1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2});
        colMisregistrationBand.setData(colMisRegistrationData);
        Band rowMisregistrationBand = new Band("rowMisregistrationBand", 12, 16, 1);
        ProductData rowMisRegistrationData = ProductData.createInstance((int[])new int[]{1, -2, -1, -2, -1, -2, -1, -2, -1, -2, -1, -2, -1, -2, -1, -2});
        rowMisregistrationBand.setData(rowMisRegistrationData);
        this.provider = new SynL1COlciSceneTransformProvider(colMisregistrationBand, rowMisregistrationBand);
    }

    @Test
    public void testGetForward() throws Exception {
        PixelPos resultPos = new PixelPos();
        this.provider.getModelToSceneTransform().transform((Point2D)new PixelPos(0.0, 0.0), (Point2D)resultPos);
        TestCase.assertEquals((int)1, (int)((int)resultPos.getX()));
        TestCase.assertEquals((int)1, (int)((int)resultPos.getY()));
        this.provider.getModelToSceneTransform().transform((Point2D)new PixelPos(2.0, 2.0), (Point2D)resultPos);
        TestCase.assertEquals((int)3, (int)((int)resultPos.getX()));
        TestCase.assertEquals((int)1, (int)((int)resultPos.getY()));
        this.provider.getModelToSceneTransform().transform((Point2D)new PixelPos(5.0, 7.0), (Point2D)resultPos);
        TestCase.assertEquals((int)7, (int)((int)resultPos.getX()));
        TestCase.assertEquals((int)5, (int)((int)resultPos.getY()));
        this.provider.getModelToSceneTransform().transform((Point2D)new PixelPos(13.0, 11.0), (Point2D)resultPos);
        TestCase.assertEquals((int)15, (int)((int)resultPos.getX()));
        TestCase.assertEquals((int)9, (int)((int)resultPos.getY()));
        this.provider.getModelToSceneTransform().transform((Point2D)new PixelPos(15.0, 15.0), (Point2D)resultPos);
        TestCase.assertEquals((int)17, (int)((int)resultPos.getX()));
        TestCase.assertEquals((int)13, (int)((int)resultPos.getY()));
    }

    @Test
    public void testGetInverse() throws Exception {
        PixelPos resultPos = new PixelPos();
        MathTransform2D sceneToModelTransform = this.provider.getSceneToModelTransform();
        sceneToModelTransform.transform((Point2D)new PixelPos(1.0, 1.0), (Point2D)resultPos);
        TestCase.assertEquals((int)0, (int)((int)resultPos.getX()));
        TestCase.assertEquals((int)3, (int)((int)resultPos.getY()));
        sceneToModelTransform.transform((Point2D)new PixelPos(2.0, 2.0), (Point2D)resultPos);
        TestCase.assertEquals((int)1, (int)((int)resultPos.getX()));
        TestCase.assertEquals((int)4, (int)((int)resultPos.getY()));
        sceneToModelTransform.transform((Point2D)new PixelPos(3.0, 3.0), (Point2D)resultPos);
        TestCase.assertEquals((int)2, (int)((int)resultPos.getX()));
        TestCase.assertEquals((int)5, (int)((int)resultPos.getY()));
        sceneToModelTransform.transform((Point2D)new PixelPos(4.0, 4.0), (Point2D)resultPos);
        TestCase.assertEquals((int)3, (int)((int)resultPos.getX()));
        TestCase.assertEquals((int)6, (int)((int)resultPos.getY()));
        sceneToModelTransform.transform((Point2D)new PixelPos(5.0, 5.0), (Point2D)resultPos);
        TestCase.assertEquals((int)4, (int)((int)resultPos.getX()));
        TestCase.assertEquals((int)7, (int)((int)resultPos.getY()));
        sceneToModelTransform.transform((Point2D)new PixelPos(6.0, 6.0), (Point2D)resultPos);
        TestCase.assertEquals((int)5, (int)((int)resultPos.getX()));
        TestCase.assertEquals((int)8, (int)((int)resultPos.getY()));
        sceneToModelTransform.transform((Point2D)new PixelPos(7.0, 7.0), (Point2D)resultPos);
        TestCase.assertEquals((int)6, (int)((int)resultPos.getX()));
        TestCase.assertEquals((int)9, (int)((int)resultPos.getY()));
        sceneToModelTransform.transform((Point2D)new PixelPos(8.0, 8.0), (Point2D)resultPos);
        TestCase.assertEquals((int)7, (int)((int)resultPos.getX()));
        TestCase.assertEquals((int)10, (int)((int)resultPos.getY()));
        sceneToModelTransform.transform((Point2D)new PixelPos(9.0, 9.0), (Point2D)resultPos);
        TestCase.assertEquals((int)8, (int)((int)resultPos.getX()));
        TestCase.assertEquals((int)11, (int)((int)resultPos.getY()));
        sceneToModelTransform.transform((Point2D)new PixelPos(10.0, 10.0), (Point2D)resultPos);
        TestCase.assertEquals((int)9, (int)((int)resultPos.getX()));
        TestCase.assertEquals((int)12, (int)((int)resultPos.getY()));
        sceneToModelTransform.transform((Point2D)new PixelPos(11.0, 11.0), (Point2D)resultPos);
        TestCase.assertEquals((int)10, (int)((int)resultPos.getX()));
        TestCase.assertEquals((int)13, (int)((int)resultPos.getY()));
        sceneToModelTransform.transform((Point2D)new PixelPos(12.0, 12.0), (Point2D)resultPos);
        TestCase.assertEquals((int)11, (int)((int)resultPos.getX()));
        TestCase.assertEquals((int)14, (int)((int)resultPos.getY()));
        sceneToModelTransform.transform((Point2D)new PixelPos(13.0, 13.0), (Point2D)resultPos);
        TestCase.assertEquals((int)12, (int)((int)resultPos.getX()));
        TestCase.assertEquals((int)15, (int)((int)resultPos.getY()));
        sceneToModelTransform.transform((Point2D)new PixelPos(14.0, 14.0), (Point2D)resultPos);
        TestCase.assertEquals((int)13, (int)((int)resultPos.getX()));
        TestCase.assertEquals((int)16, (int)((int)resultPos.getY()));
        sceneToModelTransform.transform((Point2D)new PixelPos(15.0, 15.0), (Point2D)resultPos);
        TestCase.assertEquals((int)14, (int)((int)resultPos.getX()));
        TestCase.assertEquals((int)17, (int)((int)resultPos.getY()));
    }
}

