/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.synergy;

import org.esa.s3tbx.dataio.s3.synergy.LonLatTiePointFunction;
import org.esa.s3tbx.dataio.s3.synergy.NcFile;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import ucar.nc2.Variable;

public class LonLatTiePointFunctionTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testApproximation() throws Exception {
        NcFile ncFile1 = null;
        NcFile ncFile2 = null;
        try {
            double[] variableData;
            ncFile1 = NcFile.openResource((String)"tiepoints_olci.nc");
            double[] lonData = ncFile1.read("OLC_TP_lon");
            double[] latData = ncFile1.read("OLC_TP_lat");
            for (Variable variable : ncFile1.getVariables(".*")) {
                variableData = ncFile1.read(variable.getName());
                this.testApproximationForVariable(lonData, latData, variableData);
            }
            ncFile2 = NcFile.openResource((String)"tiepoints_meteo.nc");
            for (Variable variable : ncFile2.getVariables(".*")) {
                variableData = ncFile2.read(variable.getName());
                this.testApproximationForVariable(lonData, latData, variableData);
            }
        }
        finally {
            if (ncFile1 != null) {
                ncFile1.close();
            }
            if (ncFile2 != null) {
                ncFile2.close();
            }
        }
    }

    private void testApproximationForVariable(double[] lonData, double[] latData, double[] variableData) {
        LonLatTiePointFunction function = new LonLatTiePointFunction(lonData, latData, variableData, lonData.length);
        for (int i = 0; i < variableData.length; ++i) {
            double lon = lonData[i];
            double lat = latData[i];
            double var = variableData[i];
            double actual = function.getValue(lon, lat);
            Assert.assertEquals((double)var, (double)actual, (double)0.0);
        }
    }
}

