/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.TestCase;
import org.esa.s3tbx.dataio.s3.Manifest;
import org.esa.s3tbx.dataio.s3.XfduManifest;
import org.esa.snap.core.datamodel.ProductData;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XfduManifestTest
extends TestCase {
    private Manifest manifestTest;

    @Before
    public void setUp() throws ParserConfigurationException, IOException, SAXException {
        try (InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("xfdumanifest.xml");){
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(stream);
            this.manifestTest = XfduManifest.createManifest((Document)doc);
        }
    }

    @Test
    public void testGetDescription() throws Exception {
        XfduManifestTest.assertEquals((String)"Sentinel 3 SYN Level 2", (String)this.manifestTest.getDescription());
    }

    @Test
    public void testGetStartTime() throws Exception {
        ProductData.UTC expected = ProductData.UTC.parse((String)"2013-06-21T10:09:20.646463", (String)"yyyy-MM-dd'T'HH:mm:ss");
        ProductData.UTC startTime = this.manifestTest.getStartTime();
        XfduManifestTest.assertTrue((boolean)expected.equalElems((ProductData)startTime));
    }

    @Test
    public void testGetStopTime() throws Exception {
        ProductData.UTC expected = ProductData.UTC.parse((String)"2013-06-21T10:14:13.646463", (String)"yyyy-MM-dd'T'HH:mm:ss");
        ProductData.UTC stopTime = this.manifestTest.getStopTime();
        XfduManifestTest.assertTrue((boolean)expected.equalElems((ProductData)stopTime));
    }

    @Test
    public void testGetFileNames() {
        String[] excluded = new String[]{};
        List fileNames = this.manifestTest.getFileNames(excluded);
        XfduManifestTest.assertEquals((int)67, (int)fileNames.size());
        XfduManifestTest.assertEquals((String)"r0400.nc", (String)((String)fileNames.get(0)));
        XfduManifestTest.assertEquals((String)"r0560.nc", (String)((String)fileNames.get(5)));
        XfduManifestTest.assertEquals((String)"r0550n.nc", (String)((String)fileNames.get(18)));
        XfduManifestTest.assertEquals((String)"r1375o.nc", (String)((String)fileNames.get(27)));
        XfduManifestTest.assertEquals((String)"flags.nc", (String)((String)fileNames.get(66)));
    }

    @Test
    public void testGetFileNames_Exclusions() {
        String[] excluded = new String[]{"aerosolModelIndex", "pixelStatusFlags"};
        List fileNames = this.manifestTest.getFileNames(excluded);
        XfduManifestTest.assertEquals((int)65, (int)fileNames.size());
        XfduManifestTest.assertEquals((boolean)false, (boolean)fileNames.contains("amin.nc"));
        XfduManifestTest.assertEquals((boolean)false, (boolean)fileNames.contains("flags.nc"));
        XfduManifestTest.assertEquals((String)"r0560.nc", (String)((String)fileNames.get(5)));
        XfduManifestTest.assertEquals((String)"r0550n.nc", (String)((String)fileNames.get(18)));
        XfduManifestTest.assertEquals((String)"r1375o.nc", (String)((String)fileNames.get(27)));
    }
}

