/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.esa.s3tbx.dataio.s3.Manifest;
import org.esa.s3tbx.dataio.s3.SafeManifest;
import org.esa.snap.core.datamodel.ProductData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SafeManifestTest {
    private Manifest manifestTest;

    @Before
    public void before() throws ParserConfigurationException, IOException, SAXException {
        try (InputStream stream = this.getClass().getResourceAsStream("SYN_TEST_manifest.safe");){
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(stream);
            this.manifestTest = SafeManifest.createManifest((Document)doc);
        }
    }

    @Test
    public void testGetDescription() throws Exception {
        Assert.assertEquals((Object)"Sentinel 3 SYN Level 2", (Object)this.manifestTest.getDescription());
    }

    @Test
    public void testGetStartTime() throws Exception {
        ProductData.UTC expected = ProductData.UTC.parse((String)"2013-06-21T10:09:20", (String)"yyyy-MM-dd'T'HH:mm:ss");
        ProductData.UTC startTime = this.manifestTest.getStartTime();
        Assert.assertTrue((boolean)expected.equalElems((ProductData)startTime));
    }

    @Test
    public void testGetStopTime() throws Exception {
        ProductData.UTC expected = ProductData.UTC.parse((String)"2013-06-21T10:14:13", (String)"yyyy-MM-dd'T'HH:mm:ss");
        ProductData.UTC stopTime = this.manifestTest.getStopTime();
        Assert.assertTrue((boolean)expected.equalElems((ProductData)stopTime));
    }

    @Test
    public void testGetMeasurementFileNames() {
        List measurementFiles = this.manifestTest.getFileNames("measurementDataSchema");
        Assert.assertEquals((long)34L, (long)measurementFiles.size());
        Assert.assertEquals((Object)"r0400.nc", measurementFiles.get(0));
        Assert.assertEquals((Object)"r0560.nc", measurementFiles.get(5));
        Assert.assertEquals((Object)"r0550n.nc", measurementFiles.get(18));
        Assert.assertEquals((Object)"r1375o.nc", measurementFiles.get(27));
        Assert.assertEquals((Object)"flags.nc", measurementFiles.get(33));
    }

    @Test
    public void testGetTiepointFileNames() {
        List tiepointsFiles = this.manifestTest.getFileNames("tiepointsSchema");
        Assert.assertEquals((long)4L, (long)tiepointsFiles.size());
        Assert.assertEquals((Object)"tiepoints_meteo.nc", tiepointsFiles.get(0));
        Assert.assertEquals((Object)"tiepoints_olci.nc", tiepointsFiles.get(1));
        Assert.assertEquals((Object)"tiepoints_slstr_n.nc", tiepointsFiles.get(2));
        Assert.assertEquals((Object)"tiepoints_slstr_o.nc", tiepointsFiles.get(3));
    }
}

