/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.esa.s3tbx.dataio.s3.EarthExplorerManifest;
import org.esa.s3tbx.dataio.s3.Manifest;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class EarthExplorerManifestTest {
    private Manifest manifest;

    @Before
    public void before() throws ParserConfigurationException, IOException, SAXException {
        try (InputStream stream = this.getClass().getResourceAsStream("Earth_Explorer_manifest.xml");){
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(stream);
            this.manifest = EarthExplorerManifest.createManifest((Document)doc);
        }
    }

    @Test
    public void testGetDescription() {
        Assert.assertEquals((Object)"Sentinel 3 Level 1B Product", (Object)this.manifest.getDescription());
    }

    @Test
    public void testGetStartTime() throws ParseException {
        ProductData.UTC expected = ProductData.UTC.parse((String)"2013-06-21T10:09:20.659100", (String)"yyyy-MM-dd'T'HH:mm:ss");
        Assert.assertTrue((boolean)expected.equalElems((ProductData)this.manifest.getStartTime()));
    }

    @Test
    public void testGetStopTime() throws ParseException {
        ProductData.UTC expected = ProductData.UTC.parse((String)"2013-06-21T10:14:12.597100", (String)"yyyy-MM-dd'T'HH:mm:ss");
        Assert.assertTrue((boolean)expected.equalElems((ProductData)this.manifest.getStopTime()));
    }

    @Test
    public void testGetMetadata() {
        MetadataElement manifestElement = this.manifest.getMetadata();
        Assert.assertNotNull((Object)manifestElement);
        Assert.assertEquals((Object)"Manifest", (Object)manifestElement.getName());
        Assert.assertEquals((long)0L, (long)manifestElement.getNumAttributes());
        Assert.assertEquals((long)1L, (long)manifestElement.getNumElements());
        MetadataElement headerElement = manifestElement.getElement("Earth_Explorer_Header");
        Assert.assertNotNull((Object)headerElement);
        Assert.assertEquals((long)2L, (long)headerElement.getNumElements());
        MetadataElement fixedHeaderElement = headerElement.getElement("Fixed_Header");
        Assert.assertNotNull((Object)fixedHeaderElement);
        Assert.assertEquals((long)7L, (long)fixedHeaderElement.getNumAttributes());
        Assert.assertEquals((Object)"TEST", (Object)fixedHeaderElement.getAttributeString("File_Class"));
        MetadataElement validityPeriodElement = fixedHeaderElement.getElement("Validity_Period");
        Assert.assertNotNull((Object)validityPeriodElement);
        Assert.assertEquals((long)2L, (long)validityPeriodElement.getNumAttributes());
    }
}

