/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.util;

import java.io.IOException;
import org.esa.s3tbx.dataio.s3.util.S3NetcdfReader;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import ucar.nc2.Variable;

public class TieMeteoReader
extends S3NetcdfReader {
    public TieMeteoReader(String pathToFile) throws IOException {
        super(pathToFile);
    }

    @Override
    protected String[] getSeparatingDimensions() {
        return new String[]{"wind_vectors", "tie_pressure_levels"};
    }

    @Override
    public String[] getSuffixesForSeparatingDimensions() {
        return new String[]{"vector", "pressure_level"};
    }

    @Override
    protected void addVariableMetadata(Variable variable, Product product) {
        super.addVariableMetadata(variable, product);
        if (variable.getFullName().equals("atmospheric_temperature_profile")) {
            MetadataElement atmosphericTemperatureProfileElement = product.getMetadataRoot().getElement("Variable_Attributes").getElement("atmospheric_temperature_profile");
            try {
                Variable referencePressureLevelVariable = this.getNetcdfFile().findVariable("reference_pressure_level");
                ProductData referencePressureLevelData = ProductData.createInstance((float[])((float[])referencePressureLevelVariable.read().copyTo1DJavaArray()));
                MetadataAttribute referencePressureLevelAttribute = new MetadataAttribute("reference_pressure_level", referencePressureLevelData, true);
                referencePressureLevelAttribute.setUnit(referencePressureLevelVariable.getUnitsString());
                referencePressureLevelAttribute.setDescription(referencePressureLevelVariable.getDescription());
                atmosphericTemperatureProfileElement.addAttribute(referencePressureLevelAttribute);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

