/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.util;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.WritableRaster;
import javax.media.jai.PlanarImage;
import org.esa.snap.core.image.ResolutionLevel;
import org.esa.snap.core.image.SingleBandedOpImage;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.VariableIF;

public class S3VariableOpImage
extends SingleBandedOpImage {
    private final VariableIF variable;
    private ArrayConverter converter;
    private int xIndex;
    private int yIndex;
    private int[] additionalDimensionIndexes;
    private String[] additionalDimensionNames;

    public S3VariableOpImage(VariableIF variable, int dataBufferType, int sourceWidth, int sourceHeight, Dimension tileSize, ResolutionLevel level, String[] additionalDimensionNames, int[] additionalDimensionIndexes, int xIndex, int yIndex) {
        this(variable, dataBufferType, sourceWidth, sourceHeight, tileSize, level, additionalDimensionNames, additionalDimensionIndexes, xIndex, yIndex, ArrayConverter.IDENTITY);
    }

    static S3VariableOpImage createS3VariableOpImage(VariableIF variable, int dataBufferType, int sourceWidth, int sourceHeight, Dimension tileSize, ResolutionLevel level, String[] additionalDimensionNames, int[] additionalDimensionIndexes, int xIndex, int yIndex, boolean msb) {
        if (msb) {
            return new S3VariableOpImage(variable, dataBufferType, sourceWidth, sourceHeight, tileSize, level, additionalDimensionNames, additionalDimensionIndexes, xIndex, yIndex, ArrayConverter.MSB);
        }
        return new S3VariableOpImage(variable, dataBufferType, sourceWidth, sourceHeight, tileSize, level, additionalDimensionNames, additionalDimensionIndexes, xIndex, yIndex, ArrayConverter.LSB);
    }

    public S3VariableOpImage(VariableIF variable, int dataBufferType, int sourceWidth, int sourceHeight, Dimension tileSize, ResolutionLevel level, String[] additionalDimensionNames, int[] additionalDimensionIndexes, int xIndex, int yIndex, ArrayConverter converter) {
        super(dataBufferType, sourceWidth, sourceHeight, tileSize, null, level);
        this.variable = variable;
        this.additionalDimensionNames = additionalDimensionNames;
        this.additionalDimensionIndexes = additionalDimensionIndexes;
        this.xIndex = xIndex;
        this.yIndex = yIndex;
        this.converter = converter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeRect(PlanarImage[] sourceImages, WritableRaster tile, Rectangle rectangle) {
        Array array;
        int rank = this.variable.getRank();
        int[] origin = new int[rank];
        int[] shape = new int[rank];
        int[] stride = new int[rank];
        for (int i = 0; i < rank; ++i) {
            shape[i] = 1;
            origin[i] = 0;
            stride[i] = 1;
        }
        int indexX = this.xIndex;
        int indexY = this.yIndex;
        shape[indexX] = this.getSourceWidth(rectangle.width);
        shape[indexY] = this.getSourceHeight(rectangle.height);
        origin[indexX] = this.getSourceX(rectangle.x) + this.getSourceOriginX();
        origin[indexY] = this.getSourceY(rectangle.y) + this.getSourceOriginY();
        double scale = this.getScale();
        stride[indexX] = (int)scale;
        stride[indexY] = (int)scale;
        for (int i = 0; i < this.additionalDimensionIndexes.length; ++i) {
            int dimensionIndex1 = this.variable.findDimensionIndex(this.additionalDimensionNames[i]);
            origin[dimensionIndex1] = this.additionalDimensionIndexes[i];
            stride[dimensionIndex1] = (int)scale;
        }
        NetcdfFile netcdfFile = this.variable.getParentGroup().getNetcdfFile();
        synchronized (netcdfFile) {
            try {
                Section section = new Section(origin, shape, stride);
                array = this.variable.read(section);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        array = this.converter.convert(array);
        tile.setDataElements(rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.transformStorage(array));
    }

    protected int getSourceOriginX() {
        return 0;
    }

    protected int getSourceOriginY() {
        return 0;
    }

    protected Object transformStorage(Array array) {
        return array.getStorage();
    }

    static interface ArrayConverter {
        public static final ArrayConverter IDENTITY = new ArrayConverter(){

            @Override
            public Array convert(Array array) {
                return array;
            }
        };
        public static final ArrayConverter LSB = new ArrayConverter(){

            @Override
            public Array convert(Array array) {
                Array convertedArray = Array.factory((DataType)DataType.INT, (int[])array.getShape());
                int i = 0;
                while ((long)i < convertedArray.getSize()) {
                    convertedArray.setInt(i, (int)(array.getLong(i) & 0xFFFFFFFFL));
                    ++i;
                }
                return convertedArray;
            }
        };
        public static final ArrayConverter MSB = new ArrayConverter(){

            @Override
            public Array convert(Array array) {
                Array convertedArray = Array.factory((DataType)DataType.INT, (int[])array.getShape());
                int i = 0;
                while ((long)i < convertedArray.getSize()) {
                    convertedArray.setInt(i, (int)(array.getLong(i) >>> 32));
                    ++i;
                }
                return convertedArray;
            }
        };
        public static final ArrayConverter UINTCONVERTER = new ArrayConverter(){

            @Override
            public Array convert(Array array) {
                Array convertedArray = Array.factory((DataType)DataType.FLOAT, (int[])array.getShape());
                int i = 0;
                while ((long)i < convertedArray.getSize()) {
                    convertedArray.setFloat(i, array.getFloat(i));
                    ++i;
                }
                return convertedArray;
            }
        };

        public Array convert(Array var1);
    }
}

