/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.synergy;

import java.io.IOException;
import org.esa.s3tbx.dataio.s3.util.S3NetcdfReader;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.nc2.Variable;

public class VgtReader
extends S3NetcdfReader {
    public VgtReader(String pathToFile) throws IOException {
        super(pathToFile);
    }

    @Override
    protected String[][] getRowColumnNamePairs() {
        return new String[][]{{"latitude", "longitude"}};
    }

    @Override
    protected void addGeoCoding(Product product) {
        try {
            Variable longitudeVariable = this.getNetcdfFile().findVariable("longitude");
            Array lonData = longitudeVariable.read();
            Variable latitudeVariable = this.getNetcdfFile().findVariable("latitude");
            Array latData = latitudeVariable.read();
            int lonSize = longitudeVariable.getShape(0);
            Index i0 = lonData.getIndex().set(0);
            Index i1 = lonData.getIndex().set(lonSize - 1);
            int sceneRasterWidth = product.getSceneRasterWidth();
            double pixelSizeX = (lonData.getDouble(i1) - lonData.getDouble(i0)) / (double)(sceneRasterWidth - 1);
            double easting = lonData.getDouble(i0);
            int latSize = latitudeVariable.getShape(0);
            Index j0 = latData.getIndex().set(0);
            Index j1 = latData.getIndex().set(latSize - 1);
            int sceneRasterHeight = product.getSceneRasterHeight();
            double pixelSizeY = (latData.getDouble(j1) - latData.getDouble(j0)) / (double)(sceneRasterHeight - 1);
            double pixelX = 0.5;
            double pixelY = 0.5;
            pixelSizeY = -pixelSizeY;
            double northing = latData.getDouble(latData.getIndex().set(0));
            if (pixelSizeX <= 0.0 || pixelSizeY <= 0.0) {
                return;
            }
            product.setSceneGeoCoding((GeoCoding)new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, sceneRasterWidth, sceneRasterHeight, easting, northing, pixelSizeX, pixelSizeY, pixelX, pixelY));
        }
        catch (IOException | FactoryException | TransformException e) {
            e.printStackTrace();
        }
    }
}

