/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.synergy;

import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.esa.s3tbx.dataio.s3.AbstractProductFactory;
import org.esa.s3tbx.dataio.s3.LonLatMultiLevelSource;
import org.esa.s3tbx.dataio.s3.Manifest;
import org.esa.s3tbx.dataio.s3.Sentinel3ProductReader;
import org.esa.s3tbx.dataio.s3.synergy.LonLatTiePointFunction;
import org.esa.s3tbx.dataio.s3.synergy.NcFile;
import org.esa.s3tbx.dataio.s3.util.S3NetcdfReader;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import ucar.nc2.Variable;

public class SynLevel2ProductFactory
extends AbstractProductFactory {
    private static final String[] excludedIDs = new String[]{"time_Data", "tiepoints_olci_Data", "tiepoints_slstr_n_Data", "tiepoints_slstr_o_Data", "tiepoints_meteo_Data"};

    public SynLevel2ProductFactory(Sentinel3ProductReader productReader) {
        super(productReader);
    }

    @Override
    protected List<String> getFileNames(Manifest manifest) {
        return manifest.getFileNames(excludedIDs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addSpecialVariables(Product masterProduct, Product targetProduct) throws IOException {
        double[] sloTpLat;
        double[] sloTpLon;
        double[] slnTpLat;
        double[] slnTpLon;
        double[] olcTpLat;
        double[] olcTpLon;
        try (NcFile olcTiePoints = this.openNcFile("tiepoints_olci.nc");){
            olcTpLon = olcTiePoints.read("OLC_TP_lon");
            olcTpLat = olcTiePoints.read("OLC_TP_lat");
        }
        this.addVariables(targetProduct, olcTpLon, olcTpLat, "tiepoints_olci.nc");
        this.addVariables(targetProduct, olcTpLon, olcTpLat, "tiepoints_meteo.nc");
        try (NcFile slnTiePoints = this.openNcFile("tiepoints_slstr_n.nc");){
            slnTpLon = slnTiePoints.read("SLN_TP_lon");
            slnTpLat = slnTiePoints.read("SLN_TP_lat");
        }
        this.addVariables(targetProduct, slnTpLon, slnTpLat, "tiepoints_slstr_n.nc");
        try (NcFile sloTiePoints = this.openNcFile("tiepoints_slstr_o.nc");){
            sloTpLon = sloTiePoints.read("SLO_TP_lon");
            sloTpLat = sloTiePoints.read("SLO_TP_lat");
        }
        this.addVariables(targetProduct, sloTpLon, sloTpLat, "tiepoints_slstr_o.nc");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addVariables(Product targetProduct, double[] tpLon, double[] tpLat, String fileName) throws IOException {
        String latBandName = "lat";
        String lonBandName = "lon";
        Band latBand = targetProduct.getBand("lat");
        Band lonBand = targetProduct.getBand("lon");
        try (NcFile ncFile = this.openNcFile(fileName);){
            List<Variable> variables = ncFile.getVariables(".*");
            for (Variable variable : variables) {
                String targetBandName = variable.getFullName();
                Band targetBand = targetProduct.addBand(targetBandName, 30);
                targetBand.setDescription(variable.getDescription());
                targetBand.setUnit(variable.getUnitsString());
                double[] tpVar = ncFile.read(variable.getFullName());
                MultiLevelImage targetImage = this.createTiePointImage(lonBand.getGeophysicalImage(), latBand.getGeophysicalImage(), tpLon, tpLat, tpVar, 400);
                targetBand.setSourceImage(targetImage);
            }
        }
    }

    private NcFile openNcFile(String fileName) throws IOException {
        return NcFile.open(new File(this.getInputFileParentDirectory(), fileName));
    }

    private MultiLevelImage createTiePointImage(MultiLevelImage lonImage, MultiLevelImage latImage, double[] tpLonData, double[] tpLatData, double[] tpFunctionData, int colCount) {
        LonLatTiePointFunction function = new LonLatTiePointFunction(tpLonData, tpLatData, tpFunctionData, colCount);
        return new DefaultMultiLevelImage(LonLatMultiLevelSource.create((MultiLevelSource)lonImage, (MultiLevelSource)latImage, function, 4));
    }

    @Override
    protected void configureTargetNode(Band sourceBand, RasterDataNode targetNode) {
        MetadataElement element;
        MetadataElement variableAttributes;
        if (targetNode instanceof Band && (variableAttributes = sourceBand.getProduct().getMetadataRoot().getElement("Variable_Attributes")) != null && (element = variableAttributes.getElement(sourceBand.getName())) != null) {
            MetadataAttribute wavelengthAttribute = element.getAttribute("wavelength");
            MetadataAttribute bandwidthAttribute = element.getAttribute("bandwidth");
            Band targetBand = (Band)targetNode;
            if (wavelengthAttribute != null) {
                targetBand.setSpectralWavelength(wavelengthAttribute.getData().getElemFloat());
            }
            if (bandwidthAttribute != null) {
                targetBand.setSpectralBandwidth(bandwidthAttribute.getData().getElemFloat());
            }
        }
    }

    @Override
    protected void setGeoCoding(Product targetProduct) throws IOException {
    }

    @Override
    protected void setAutoGrouping(Product[] sourceProducts, Product targetProduct) {
        targetProduct.setAutoGrouping("SDR:SDR*err:OLC:SLN:SLO");
    }

    @Override
    protected Product readProduct(String fileName) throws IOException {
        File file = new File(this.getInputFileParentDirectory(), fileName);
        if (!file.exists()) {
            return null;
        }
        S3NetcdfReader reader = new S3NetcdfReader(file.getAbsolutePath());
        return reader.readProduct();
    }
}

