/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.synergy;

import java.awt.geom.Point2D;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.SceneTransformProvider;
import org.esa.snap.core.transform.AbstractTransform2D;
import org.esa.snap.core.transform.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public class SynL1CSlstrSceneTransformProvider
implements SceneTransformProvider {
    private final SynL1CSceneToModelTransform sceneToModelTransform;

    public SynL1CSlstrSceneTransformProvider(Band colCorrespondenceBand, Band rowCorrespondenceBand) {
        this.sceneToModelTransform = new SynL1CSceneToModelTransform(colCorrespondenceBand, rowCorrespondenceBand);
    }

    public MathTransform2D getModelToSceneTransform() {
        return MathTransform2D.NULL;
    }

    public MathTransform2D getSceneToModelTransform() {
        return this.sceneToModelTransform;
    }

    private class SynL1CSceneToModelTransform
    extends AbstractTransform2D {
        private final Band colCorrespondenceBand;
        private final Band rowCorrespondenceBand;

        private SynL1CSceneToModelTransform(Band colCorrespondenceBand, Band rowCorrespondenceBand) {
            this.colCorrespondenceBand = colCorrespondenceBand;
            this.rowCorrespondenceBand = rowCorrespondenceBand;
        }

        public Point2D transform(Point2D ptSrc, Point2D ptDst) throws TransformException {
            double srcPtX = ptSrc.getX();
            double srcPtY = ptSrc.getY();
            if (Double.isNaN(srcPtX) || Double.isNaN(srcPtY) || srcPtX < 0.0 || srcPtX >= (double)this.colCorrespondenceBand.getRasterWidth() || srcPtY < 0.0 || srcPtY >= (double)this.colCorrespondenceBand.getRasterHeight()) {
                throw new TransformException("Could not transform");
            }
            int columnCorrespondence = this.colCorrespondenceBand.getSampleInt((int)srcPtX, (int)srcPtY);
            int rowCorrespondence = this.rowCorrespondenceBand.getSampleInt((int)srcPtX, (int)srcPtY);
            if (columnCorrespondence < 0 || rowCorrespondence < 0) {
                throw new TransformException("Could not transform");
            }
            if (ptDst == null) {
                ptDst = new Point2D.Double();
            }
            ptDst.setLocation(columnCorrespondence, rowCorrespondence);
            return ptDst;
        }

        public MathTransform2D inverse() throws NoninvertibleTransformException {
            throw new NoninvertibleTransformException("Cannot invert transformation");
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof SynL1CSceneToModelTransform)) {
                return false;
            }
            return ((SynL1CSceneToModelTransform)((Object)object)).colCorrespondenceBand == this.colCorrespondenceBand && ((SynL1CSceneToModelTransform)((Object)object)).rowCorrespondenceBand == this.rowCorrespondenceBand;
        }

        public int hashCode() {
            return this.colCorrespondenceBand.getName().hashCode() + this.rowCorrespondenceBand.getName().hashCode();
        }
    }
}

