/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.synergy;

import com.bc.ceres.glevel.MultiLevelImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.s3tbx.dataio.s3.AbstractProductFactory;
import org.esa.s3tbx.dataio.s3.Manifest;
import org.esa.s3tbx.dataio.s3.Sentinel3ProductReader;
import org.esa.s3tbx.dataio.s3.synergy.CameraImageMosaic;
import org.esa.s3tbx.dataio.s3.synergy.Partitioner;
import org.esa.s3tbx.dataio.s3.synergy.SynL1COlciSceneTransformProvider;
import org.esa.s3tbx.dataio.s3.synergy.SynL1CSceneTransformGeoCoding;
import org.esa.s3tbx.dataio.s3.synergy.SynL1CSlstrSceneTransformProvider;
import org.esa.s3tbx.dataio.s3.synergy.SynNetcdfReaderFactory;
import org.esa.s3tbx.dataio.s3.util.S3NetcdfReader;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.BasicPixelGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoCodingFactory;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.transform.MathTransform2D;
import org.esa.snap.core.util.ProductUtils;

public class SynL1CProductFactory
extends AbstractProductFactory {
    public SynL1CProductFactory(Sentinel3ProductReader productReader) {
        super(productReader);
    }

    @Override
    protected List<String> getFileNames(Manifest manifest) {
        List<String> manifestFileNames = manifest.getFileNames("M");
        ArrayList<String> fileNames = new ArrayList<String>();
        for (String manifestFileName : manifestFileNames) {
            if (manifestFileName.contains("/")) {
                manifestFileName = manifestFileName.substring(manifestFileName.lastIndexOf("/") + 1);
            }
            if (manifestFileName.equals("MISREGIST_OLC_Oref_O17.nc") || manifestFileName.contains("QUALITY_INFO")) continue;
            fileNames.add(manifestFileName);
        }
        fileNames.add("GEOLOCATION_REF.nc");
        return fileNames;
    }

    @Override
    protected int getSceneRasterWidth(Product masterProduct) {
        return masterProduct.getSceneRasterWidth() * 5;
    }

    @Override
    protected void addDataNodes(Product masterProduct, Product targetProduct) throws IOException {
        for (Product sourceProduct : this.getOpenProductList()) {
            HashMap<String, String> mapping = new HashMap<String, String>();
            Map<String, List<String>> partition = Partitioner.partition(sourceProduct.getBandNames(), "_CAM");
            for (Map.Entry<String, List<String>> entry : partition.entrySet()) {
                MultiLevelImage sourceImage;
                String targetBandName = sourceProduct.getName() + "_" + entry.getKey();
                List<String> sourceBandNames = entry.getValue();
                String sourceBandName = sourceBandNames.get(0);
                Band sourceBand = sourceProduct.getBand(sourceBandName);
                if (sourceBandNames.size() > 1) {
                    MultiLevelImage[] sourceImages = new MultiLevelImage[sourceBandNames.size()];
                    for (int i = 0; i < sourceImages.length; ++i) {
                        sourceImages[i] = sourceProduct.getBand(sourceBandNames.get(i)).getSourceImage();
                    }
                    sourceImage = CameraImageMosaic.create(sourceImages);
                } else {
                    sourceImage = sourceBand.getSourceImage();
                }
                Band targetBand = new Band(targetBandName, sourceBand.getDataType(), sourceImage.getWidth(), sourceImage.getHeight());
                ProductUtils.copyRasterDataNodeProperties((RasterDataNode)sourceBand, (RasterDataNode)targetBand);
                targetProduct.addBand(targetBand);
                targetBand.setNoDataValueUsed(false);
                targetBand.setValidPixelExpression("");
                targetBand.setSourceImage(sourceImage);
                this.configureTargetNode(sourceBand, (RasterDataNode)targetBand);
                mapping.put(sourceBand.getName(), targetBand.getName());
            }
            this.copyMasks(targetProduct, sourceProduct, mapping);
        }
        this.addCameraIndexBand(targetProduct, masterProduct.getSceneRasterWidth());
    }

    @Override
    protected void setSceneTransforms(Product product) {
        Band[] bands;
        for (Band band : bands = product.getBands()) {
            Band rowCorrespondenceBand;
            Band columnCorrespondenceBand;
            String bandName = band.getName();
            Object sceneTransformProvider = null;
            if (bandName.startsWith("OLC_RADIANCE") && !bandName.contains("17")) {
                int end = 16;
                if (bandName.substring(15, 16).equals("_")) {
                    end = 15;
                }
                String identifier = bandName.substring(14, end);
                Band rowMisregistrationBand = product.getBand("MISREGIST_OLC_Oref_O" + identifier + "_delta_row");
                Band columnMisregistrationBand = product.getBand("MISREGIST_OLC_Oref_O" + identifier + "_delta_col");
                sceneTransformProvider = new SynL1COlciSceneTransformProvider(columnMisregistrationBand, rowMisregistrationBand);
            } else if (bandName.startsWith("SLST_NAD_RADIANCE")) {
                String identifier = bandName.substring(19, 20);
                columnCorrespondenceBand = product.getBand("MISREGIST_SLST_NAD_Oref_S" + identifier + "_col_corresp");
                rowCorrespondenceBand = product.getBand("MISREGIST_SLST_NAD_Oref_S" + identifier + "_row_corresp");
                sceneTransformProvider = new SynL1CSlstrSceneTransformProvider(columnCorrespondenceBand, rowCorrespondenceBand);
            } else if (bandName.startsWith("SLST_NAD_BT_S")) {
                String identifier = bandName.substring(13, 14);
                columnCorrespondenceBand = product.getBand("MISREGIST_SLST_NAD_Oref_S" + identifier + "_col_corresp");
                rowCorrespondenceBand = product.getBand("MISREGIST_SLST_NAD_Oref_S" + identifier + "_row_corresp");
                sceneTransformProvider = new SynL1CSlstrSceneTransformProvider(columnCorrespondenceBand, rowCorrespondenceBand);
            } else if (bandName.startsWith("SLST_NAD_BT_F")) {
                String identifier = bandName.substring(13, 14);
                columnCorrespondenceBand = product.getBand("MISREGIST_SLST_NAD_Oref_F" + identifier + "_col_corresp");
                rowCorrespondenceBand = product.getBand("MISREGIST_SLST_NAD_Oref_F" + identifier + "_row_corresp");
                sceneTransformProvider = new SynL1CSlstrSceneTransformProvider(columnCorrespondenceBand, rowCorrespondenceBand);
            }
            if (sceneTransformProvider == null) continue;
            band.setModelToSceneTransform(sceneTransformProvider.getModelToSceneTransform());
            band.setSceneToModelTransform(sceneTransformProvider.getSceneToModelTransform());
        }
    }

    private void addCameraIndexBand(Product targetProduct, int cameraImageWidth) {
        int sceneRasterWidth = targetProduct.getSceneRasterWidth();
        int sceneRasterHeight = targetProduct.getSceneRasterHeight();
        StringBuilder expression = new StringBuilder();
        int width = 0;
        for (int i = 0; i < 4; ++i) {
            expression.append("X < ").append(width += cameraImageWidth).append(" ? ");
            expression.append(i);
            expression.append(" : ");
            if (i != 3) continue;
            expression.append(i + 1);
        }
        VirtualBand cameraIndexBand = new VirtualBand("Camera_Index", 10, sceneRasterWidth, sceneRasterHeight, expression.toString());
        targetProduct.addBand((Band)cameraIndexBand);
        IndexCoding indexCoding = new IndexCoding("Camera_Index");
        for (int i = 0; i < 5; ++i) {
            String description = "Images from camera " + i;
            indexCoding.addIndex("Camera_Index_" + (i + 1), i, description);
        }
        cameraIndexBand.setSampleCoding((SampleCoding)indexCoding);
        targetProduct.getIndexCodingGroup().add((ProductNode)indexCoding);
    }

    @Override
    protected Band addBand(Band sourceBand, Product targetProduct) {
        String sourceBandName = sourceBand.getName();
        sourceBand.setName(sourceBand.getProduct().getName() + "_" + sourceBandName);
        return super.addBand(sourceBand, targetProduct);
    }

    @Override
    protected Product readProduct(String fileName) throws IOException {
        File file = new File(this.getInputFileParentDirectory(), fileName);
        if (!file.exists()) {
            return null;
        }
        S3NetcdfReader synNetcdfReader = SynNetcdfReaderFactory.createSynNetcdfReader(file);
        return synNetcdfReader.readProduct();
    }

    @Override
    protected void setGeoCoding(Product targetProduct) throws IOException {
        ProductNodeGroup bandGroup = targetProduct.getBandGroup();
        if (bandGroup.contains("GEOLOCATION_REF_latitude") && bandGroup.contains("GEOLOCATION_REF_longitude")) {
            BasicPixelGeoCoding pixelGeoCoding = GeoCodingFactory.createPixelGeoCoding((Band)((Band)bandGroup.get("GEOLOCATION_REF_latitude")), (Band)((Band)bandGroup.get("GEOLOCATION_REF_longitude")), (String)"", (int)5);
            targetProduct.setSceneGeoCoding((GeoCoding)pixelGeoCoding);
        }
    }

    @Override
    protected void setBandGeoCodings(Product targetProduct) {
        Band[] bands;
        for (Band band : bands = targetProduct.getBands()) {
            MathTransform2D sceneToModelTransform = band.getSceneToModelTransform();
            MathTransform2D modelToSceneTransform = band.getModelToSceneTransform();
            if (sceneToModelTransform == MathTransform2D.IDENTITY && modelToSceneTransform == MathTransform2D.IDENTITY) continue;
            band.setGeoCoding((GeoCoding)new SynL1CSceneTransformGeoCoding(targetProduct.getSceneGeoCoding(), sceneToModelTransform, modelToSceneTransform));
        }
    }

    @Override
    protected void setAutoGrouping(Product[] sourceProducts, Product targetProduct) {
        targetProduct.setAutoGrouping("Meas:error_estimates:exception:MISREGIST_OLC:MISREGIST_SLST:GEOLOCATION_REF");
    }
}

