/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.synergy;

import java.util.Arrays;
import java.util.Comparator;
import org.esa.s3tbx.dataio.s3.LonLatFunction;
import org.esa.snap.core.util.math.DistanceMeasure;

final class LonLatTiePointFunction
implements LonLatFunction {
    private final double[][] data;
    private final Comparator<double[]> comparator = new Comparator<double[]>(){

        @Override
        public int compare(double[] o1, double[] o2) {
            return Double.compare(o1[1], o2[1]);
        }
    };
    private final int pixelCount;

    LonLatTiePointFunction(double[] lonData, double[] latData, double[] functionData, int pixelCount) {
        this.pixelCount = pixelCount;
        this.data = new double[lonData.length][3];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i][0] = lonData[i];
            this.data[i][1] = latData[i];
            this.data[i][2] = functionData[i];
        }
        Arrays.sort(this.data, this.comparator);
    }

    @Override
    public double getValue(double lon, double lat) {
        int index = Math.abs(Arrays.binarySearch(this.data, new double[]{0.0, lat, 0.0}, this.comparator));
        DC distanceCalculator = new DC(lon, lat);
        int minIndex = Math.max(0, index - this.pixelCount - 2);
        int maxIndex = Math.min(this.data.length, index + this.pixelCount + 2);
        double value = Double.NaN;
        double minDistance = Double.MAX_VALUE;
        for (int k = minIndex; k < maxIndex; ++k) {
            double[] point = this.data[k];
            double distance = distanceCalculator.distance(point[0], point[1]);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            value = point[2];
        }
        return value;
    }

    private static final class DC
    implements DistanceMeasure {
        private final double lon;
        private final double si;
        private final double co;

        private DC(double lon, double lat) {
            this.lon = lon;
            this.si = Math.sin(Math.toRadians(lat));
            this.co = Math.cos(Math.toRadians(lat));
        }

        public double distance(double lon, double lat) {
            double phi = Math.toRadians(lat);
            return -(this.si * Math.sin(phi) + this.co * Math.cos(phi) * Math.cos(Math.toRadians(lon - this.lon)));
        }
    }
}

