/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.synergy;

import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import com.bc.ceres.glevel.support.DefaultMultiLevelSource;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import javax.media.jai.Interpolation;
import javax.media.jai.operator.MosaicDescriptor;
import javax.media.jai.operator.MosaicType;
import javax.media.jai.operator.ScaleDescriptor;
import javax.media.jai.operator.TranslateDescriptor;

class CameraImageMosaic {
    private static final Interpolation INTERPOLATION = Interpolation.getInstance((int)0);

    CameraImageMosaic() {
    }

    static RenderedImage create(RenderedImage ... sourceImages) {
        double[][] sourceThresholds = new double[sourceImages.length][1];
        sourceThresholds[0][0] = CameraImageMosaic.determineSourceThreshold(sourceImages[0]);
        int t = 0;
        for (int i = 1; i < sourceImages.length; ++i) {
            sourceImages[i] = TranslateDescriptor.create((RenderedImage)sourceImages[i], (Float)Float.valueOf(t += sourceImages[i - 1].getWidth()), (Float)Float.valueOf(0.0f), (Interpolation)INTERPOLATION, null);
            sourceThresholds[i][0] = CameraImageMosaic.determineSourceThreshold(sourceImages[i]);
        }
        return MosaicDescriptor.create((RenderedImage[])sourceImages, (MosaicType)MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])sourceThresholds, null, null);
    }

    private static double determineSourceThreshold(RenderedImage image) {
        int dataType = image.getSampleModel().getDataType();
        switch (dataType) {
            case 0: {
                return -128.0;
            }
            case 1: {
                return 1.0;
            }
            case 2: {
                return -32767.0;
            }
            case 3: {
                return -2.147483647E9;
            }
            case 4: {
                return 1.0;
            }
            case 5: {
                return 1.0;
            }
        }
        return 0.0;
    }

    public static MultiLevelImage create(final MultiLevelImage ... sourceImages) {
        int mosaicWidth = CameraImageMosaic.mosaicWidth(sourceImages);
        int mosaicHeight = sourceImages[0].getHeight();
        final Rectangle mosaicBounds = new Rectangle(mosaicWidth, mosaicHeight);
        DefaultMultiLevelModel model = new DefaultMultiLevelModel(sourceImages[0].getModel().getLevelCount(), new AffineTransform(), mosaicWidth, mosaicHeight);
        AbstractMultiLevelSource mosaicMultiLevelSource = new AbstractMultiLevelSource((MultiLevelModel)model, (MultiLevelModel)model){
            final /* synthetic */ MultiLevelModel val$model;
            {
                this.val$model = multiLevelModel;
                super(x0);
            }

            protected RenderedImage createImage(int level) {
                RenderedImage[] levelImages = new RenderedImage[sourceImages.length];
                for (int i = 0; i < levelImages.length; ++i) {
                    levelImages[i] = sourceImages[i].getImage(level);
                }
                RenderedImage levelMosaic = CameraImageMosaic.create(levelImages);
                int expectedWidth = this.expectedLevelImageWidth(mosaicBounds, this.val$model.getScale(level));
                if (expectedWidth != levelMosaic.getWidth()) {
                    float scale = (float)expectedWidth / (float)levelMosaic.getWidth();
                    levelMosaic = ScaleDescriptor.create((RenderedImage)levelMosaic, (Float)Float.valueOf(scale), (Float)Float.valueOf(1.0f), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Interpolation)INTERPOLATION, null);
                }
                return levelMosaic;
            }

            private int expectedLevelImageWidth(Rectangle mosaicBounds2, double scale) {
                Rectangle levelBounds = DefaultMultiLevelSource.getLevelImageBounds((Rectangle)mosaicBounds2, (double)scale);
                return levelBounds.width;
            }
        };
        return new DefaultMultiLevelImage((MultiLevelSource)mosaicMultiLevelSource);
    }

    private static int mosaicWidth(MultiLevelImage[] sourceImages) {
        int w = 0;
        for (MultiLevelImage sourceImage : sourceImages) {
            w += sourceImage.getWidth();
        }
        return w;
    }
}

