/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.slstr;

import java.io.IOException;
import org.esa.s3tbx.dataio.s3.Sentinel3ProductReader;
import org.esa.s3tbx.dataio.s3.slstr.SlstrSstProductFactory;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.BasicPixelGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoCodingFactory;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;

public class SlstrWstProductFactory
extends SlstrSstProductFactory {
    public SlstrWstProductFactory(Sentinel3ProductReader productReader) {
        super(productReader);
    }

    @Override
    protected void setGeoCoding(Product targetProduct) throws IOException {
        String[] bandNames = targetProduct.getBandNames();
        Band latBand = null;
        Band lonBand = null;
        boolean otherBandAlreadyFound = false;
        for (String bandName : bandNames) {
            if (bandName.endsWith("lat")) {
                latBand = targetProduct.getBand(bandName);
                if (otherBandAlreadyFound) break;
                otherBandAlreadyFound = true;
                continue;
            }
            if (!bandName.endsWith("lon")) continue;
            lonBand = targetProduct.getBand(bandName);
            if (otherBandAlreadyFound) break;
            otherBandAlreadyFound = true;
        }
        if (latBand != null && lonBand != null) {
            BasicPixelGeoCoding geoCoding = GeoCodingFactory.createPixelGeoCoding(latBand, lonBand, (String)"!l2p_flags.N3_retrieval", (int)5);
            targetProduct.setSceneGeoCoding((GeoCoding)geoCoding);
        }
    }

    @Override
    protected void setAutoGrouping(Product[] sourceProducts, Product targetProduct) {
        targetProduct.setAutoGrouping("brightness_temperature:nedt");
    }

    @Override
    protected void setUncertaintyBands(Product product) {
        super.setUncertaintyBands(product);
        String[] bandNames = new String[]{"sst_theoretical_error"};
        String[] roles = new String[]{"uncertainty"};
        if (product.containsBand("sea_surface_temperature")) {
            Band seaSurfaceTemperatureBand = product.getBand("sea_surface_temperature");
            for (int i = 0; i < bandNames.length; ++i) {
                String bandName = bandNames[i];
                if (!product.containsBand(bandName)) continue;
                Band band = product.getBand(bandName);
                seaSurfaceTemperatureBand.addAncillaryVariable((RasterDataNode)band, new String[]{roles[i]});
                this.addUncertaintyImageInfo(band);
            }
        }
    }
}

