/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.slstr;

import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import org.esa.s3tbx.dataio.s3.AbstractProductFactory;
import org.esa.s3tbx.dataio.s3.Sentinel3ProductReader;
import org.esa.s3tbx.dataio.s3.slstr.SlstrNetcdfReaderFactory;
import org.esa.s3tbx.dataio.s3.util.S3NetcdfReader;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.image.SourceImageScaler;

public abstract class SlstrProductFactory
extends AbstractProductFactory {
    private double referenceStartOffset;
    private double referenceTrackOffset;
    private short[] referenceResolutions;

    protected SlstrProductFactory(Sentinel3ProductReader productReader) {
        super(productReader);
    }

    protected abstract Integer getStartOffset(String var1);

    protected abstract Integer getTrackOffset(String var1);

    protected short[] getResolutions(String gridIndex) {
        short[] resolutions = gridIndex.startsWith("i") ? new short[]{1000, 1000} : (gridIndex.startsWith("t") ? new short[]{16000, 1000} : new short[]{500, 500});
        return resolutions;
    }

    protected void setReferenceStartOffset(int startOffset) {
        this.referenceStartOffset = startOffset;
    }

    protected void setReferenceTrackOffset(int trackOffset) {
        this.referenceTrackOffset = trackOffset;
    }

    protected void setReferenceResolutions(short[] resolutions) {
        this.referenceResolutions = resolutions;
    }

    protected short[] getReferenceResolutions() {
        return this.referenceResolutions;
    }

    protected RenderedImage createSourceImage(Product masterProduct, Band sourceBand, float[] offsets, Band targetBand, short[] sourceResolutions) {
        ImageLayout imageLayout = ImageManager.createSingleBandedImageLayout((RasterDataNode)targetBand);
        RenderingHints renderingHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout);
        renderingHints.add(new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1)));
        MultiLevelImage sourceImage = sourceBand.getSourceImage();
        float[] scalings = new float[]{(float)sourceResolutions[0] / (float)this.referenceResolutions[0], (float)sourceResolutions[1] / (float)this.referenceResolutions[1]};
        MultiLevelImage masterImage = masterProduct.getBandAt(0).getSourceImage();
        return SourceImageScaler.scaleMultiLevelImage((MultiLevelImage)masterImage, (MultiLevelImage)sourceImage, (float[])scalings, (float[])offsets, (RenderingHints)renderingHints, (double)targetBand.getNoDataValue(), (Interpolation)Interpolation.getInstance((int)0));
    }

    protected float[] getOffsets(double sourceStartOffset, double sourceTrackOffset, short[] sourceResolutions) {
        float offsetX = (float)(this.referenceTrackOffset - sourceTrackOffset * (double)((float)sourceResolutions[0] / (float)this.referenceResolutions[0]));
        float offsetY = (float)(sourceStartOffset * (double)((float)sourceResolutions[1] / (float)this.referenceResolutions[1]) - this.referenceStartOffset);
        return new float[]{offsetX, offsetY};
    }

    protected RasterDataNode copyTiePointGrid(Band sourceBand, Product targetProduct, double sourceStartOffset, double sourceTrackOffset, short[] sourceResolutions) {
        int subSamplingX = sourceResolutions[0] / this.referenceResolutions[0];
        int subSamplingY = sourceResolutions[1] / this.referenceResolutions[1];
        float[] tiePointGridOffsets = this.getTiePointGridOffsets(sourceStartOffset, sourceTrackOffset, subSamplingX, subSamplingY, sourceResolutions);
        return SlstrProductFactory.copyBandAsTiePointGrid(sourceBand, targetProduct, subSamplingX, subSamplingY, tiePointGridOffsets[0], tiePointGridOffsets[1]);
    }

    protected float[] getTiePointGridOffsets(double sourceStartOffset, double sourceTrackOffset, int subSamplingX, int subSamplingY, short[] sourceResolutions) {
        float[] tiePointGridOffsets = new float[]{(float)(this.referenceTrackOffset - sourceTrackOffset * (double)subSamplingX), (float)(sourceStartOffset * (double)subSamplingY - this.referenceStartOffset)};
        return tiePointGridOffsets;
    }

    @Override
    protected void setGeoCoding(Product targetProduct) throws IOException {
        TiePointGrid latGrid = null;
        TiePointGrid lonGrid = null;
        for (TiePointGrid grid : targetProduct.getTiePointGrids()) {
            if (latGrid == null && grid.getName().endsWith("latitude_tx")) {
                latGrid = grid;
            }
            if (lonGrid != null || !grid.getName().endsWith("longitude_tx")) continue;
            lonGrid = grid;
        }
        if (latGrid != null && lonGrid != null) {
            targetProduct.setSceneGeoCoding((GeoCoding)new TiePointGeoCoding(latGrid, lonGrid));
        }
    }

    @Override
    protected void setAutoGrouping(Product[] sourceProducts, Product targetProduct) {
        targetProduct.setAutoGrouping(this.getAutoGroupingString(sourceProducts));
    }

    protected String getAutoGroupingString(Product[] sourceProducts) {
        StringBuilder patternBuilder = new StringBuilder();
        for (Product sourceProduct : sourceProducts) {
            String sourceProductName = sourceProduct.getName();
            if (sourceProduct.getAutoGrouping() != null) {
                for (String[] groups : sourceProduct.getAutoGrouping()) {
                    if (patternBuilder.length() > 0) {
                        patternBuilder.append(":");
                    }
                    patternBuilder.append(sourceProductName);
                    for (String group : groups) {
                        patternBuilder.append("/");
                        patternBuilder.append(group);
                    }
                }
            }
            String patternName = sourceProductName;
            String[] unwantedPatternContents = new String[]{"_an", "_ao", "_bn", "_bo", "_cn", "_co", "_in", "_io", "_tn", "_to", "_tx"};
            for (String unwantedPatternContent : unwantedPatternContents) {
                if (!sourceProductName.contains(unwantedPatternContent)) continue;
                patternName = sourceProductName.substring(0, sourceProductName.lastIndexOf(unwantedPatternContent));
                break;
            }
            if (patternBuilder.toString().contains(":" + patternName + ":") || patternBuilder.toString().endsWith(":" + patternName)) continue;
            if (patternBuilder.length() > 0) {
                patternBuilder.append(":");
            }
            patternBuilder.append(patternName);
        }
        return patternBuilder.toString();
    }

    @Override
    protected Product readProduct(String fileName) throws IOException {
        File file = new File(this.getInputFileParentDirectory(), fileName);
        if (!file.exists()) {
            return null;
        }
        S3NetcdfReader slstrNetcdfReader = SlstrNetcdfReaderFactory.createSlstrNetcdfReader(file);
        this.addSeparatingDimensions(slstrNetcdfReader.getSuffixesForSeparatingDimensions());
        return slstrNetcdfReader.readProduct();
    }
}

