/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.slstr;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.esa.s3tbx.dataio.s3.Manifest;
import org.esa.s3tbx.dataio.s3.Sentinel3ProductReader;
import org.esa.s3tbx.dataio.s3.slstr.SlstrL2ProductFactory;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoCodingFactory;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGeoCoding;

public class SlstrLstProductFactory
extends SlstrL2ProductFactory {
    public SlstrLstProductFactory(Sentinel3ProductReader productReader) {
        super(productReader);
    }

    @Override
    protected List<String> getFileNames(Manifest manifest) {
        File directory = this.getInputFileParentDirectory();
        String[] fileNames = directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".nc");
            }
        });
        return Arrays.asList(fileNames);
    }

    @Override
    protected void setAutoGrouping(Product[] sourceProducts, Product targetProduct) {
    }

    @Override
    protected void setGeoCoding(Product targetProduct) throws IOException {
        Band latBand = targetProduct.getBand("latitude_in");
        Band lonBand = targetProduct.getBand("longitude_in");
        if (latBand != null && lonBand != null) {
            targetProduct.setSceneGeoCoding((GeoCoding)GeoCodingFactory.createPixelGeoCoding((Band)latBand, (Band)lonBand, (String)"!confidence_in_duplicate", (int)5));
        }
        if (targetProduct.getSceneGeoCoding() == null && targetProduct.getTiePointGrid("latitude_tx") != null && targetProduct.getTiePointGrid("longitude_tx") != null) {
            targetProduct.setSceneGeoCoding((GeoCoding)new TiePointGeoCoding(targetProduct.getTiePointGrid("latitude_tx"), targetProduct.getTiePointGrid("longitude_tx")));
        }
    }

    @Override
    protected Integer getStartOffset(String gridIndex) {
        return 0;
    }

    @Override
    protected Integer getTrackOffset(String gridIndex) {
        return 0;
    }

    @Override
    protected RasterDataNode addSpecialNode(Product masterProduct, Band sourceBand, Product targetProduct) {
        int subSamplingX = 1;
        int subSamplingY = 1;
        return SlstrLstProductFactory.copyBandAsTiePointGrid(sourceBand, targetProduct, subSamplingX, subSamplingY, 0.0f, 0.0f);
    }
}

