/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.slstr;

import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import com.bc.ceres.glevel.support.DefaultMultiLevelSource;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.s3tbx.dataio.s3.Manifest;
import org.esa.s3tbx.dataio.s3.Sentinel3ProductReader;
import org.esa.s3tbx.dataio.s3.slstr.SlstrProductFactory;
import org.esa.s3tbx.dataio.s3.slstr.SlstrTiePointGeoCoding;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.BasicPixelGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoCodingFactory;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.runtime.Config;
import org.geotools.referencing.operation.transform.AffineTransform2D;

public class SlstrLevel1ProductFactory
extends SlstrProductFactory {
    private final Map<String, String> gridTypeToGridIndex = new HashMap<String, String>();
    private final Map<String, Integer> gridIndexToTrackOffset;
    private final Map<String, Integer> gridIndexToStartOffset;
    private Map<String, Float> nameToWavelengthMap;
    private Map<String, Float> nameToBandwidthMap;
    private Map<String, Integer> nameToIndexMap;
    private Map<String, GeoCoding> geoCodingMap;
    public static final String SLSTR_L1B_USE_PIXELGEOCODINGS = "s3tbx.reader.slstrl1b.pixelGeoCodings";

    public SlstrLevel1ProductFactory(Sentinel3ProductReader productReader) {
        super(productReader);
        this.gridTypeToGridIndex.put("1 km", "i");
        this.gridTypeToGridIndex.put("0.5 km stripe A", "a");
        this.gridTypeToGridIndex.put("0.5 km stripe B", "b");
        this.gridTypeToGridIndex.put("0.5 km TDI", "c");
        this.gridTypeToGridIndex.put("Tie Points", "t");
        this.gridIndexToTrackOffset = new HashMap<String, Integer>();
        this.gridIndexToStartOffset = new HashMap<String, Integer>();
        this.nameToWavelengthMap = new HashMap<String, Float>();
        this.nameToBandwidthMap = new HashMap<String, Float>();
        this.nameToIndexMap = new HashMap<String, Integer>();
        this.geoCodingMap = new HashMap<String, GeoCoding>();
    }

    @Override
    protected Integer getStartOffset(String gridIndex) {
        return this.gridIndexToStartOffset.get(gridIndex);
    }

    @Override
    protected Integer getTrackOffset(String gridIndex) {
        return this.gridIndexToTrackOffset.get(gridIndex);
    }

    @Override
    protected void processProductSpecificMetadata(MetadataElement metadataElement) {
        MetadataElement slstrInformationElement = metadataElement.getElement("slstrProductInformation");
        Product masterProduct = this.findMasterProduct();
        int numberOfMasterColumns = masterProduct.getSceneRasterWidth();
        int numberOfMasterRows = masterProduct.getSceneRasterHeight();
        for (int i = 0; i < slstrInformationElement.getNumElements(); ++i) {
            MetadataElement slstrElement = slstrInformationElement.getElementAt(i);
            String slstrElementName = slstrElement.getName();
            if (slstrElementName.endsWith("ImageSize") && slstrElement.containsAttribute("grid")) {
                String firstLetter = this.gridTypeToGridIndex.get(slstrElement.getAttribute("grid").getData().getElemString());
                String index = slstrElementName.equals("nadirImageSize") ? firstLetter + "n" : firstLetter + "o";
                int startOffset = Integer.parseInt(slstrElement.getAttribute("startOffset").getData().getElemString());
                int trackOffset = Integer.parseInt(slstrElement.getAttribute("trackOffset").getData().getElemString());
                this.gridIndexToStartOffset.put(index, startOffset);
                this.gridIndexToTrackOffset.put(index, trackOffset);
                if (firstLetter.equals("t")) {
                    this.gridIndexToStartOffset.put("tx", startOffset);
                    this.gridIndexToTrackOffset.put("tx", trackOffset);
                }
                int numberOfRows = Integer.parseInt(slstrElement.getAttribute("rows").getData().getElemString());
                int numberOfColumns = Integer.parseInt(slstrElement.getAttribute("columns").getData().getElemString());
                if (numberOfColumns == numberOfMasterColumns && numberOfRows == numberOfMasterRows) {
                    this.setReferenceStartOffset(startOffset);
                    this.setReferenceTrackOffset(trackOffset);
                    this.setReferenceResolutions(this.getResolutions(index));
                }
            }
            if (!slstrElementName.equals("bandDescriptions")) continue;
            for (int j = 0; j < slstrElement.getNumElements(); ++j) {
                float bandWidth;
                MetadataElement bandElement = slstrElement.getElementAt(j);
                String bandName = bandElement.getAttribute("name").getData().getElemString();
                float wavelength = Float.parseFloat(bandElement.getAttribute("centralWavelength").getData().getElemString());
                if (wavelength < 100.0f) {
                    wavelength *= 1000.0f;
                }
                if ((double)(bandWidth = Float.parseFloat(bandElement.getAttribute("bandWidth").getData().getElemString())) <= 1.0) {
                    bandWidth *= 1000.0f;
                }
                this.nameToWavelengthMap.put(bandName, Float.valueOf(wavelength));
                this.nameToBandwidthMap.put(bandName, Float.valueOf(bandWidth));
                this.nameToIndexMap.put(bandName, j);
            }
        }
    }

    @Override
    protected void configureTargetNode(Band sourceBand, RasterDataNode targetNode) {
        String sourceBandName = sourceBand.getName();
        String sourceBandNameStart = sourceBandName.substring(0, 2);
        if (this.nameToWavelengthMap.containsKey(sourceBandNameStart)) {
            ((Band)targetNode).setSpectralWavelength(this.nameToWavelengthMap.get(sourceBandNameStart).floatValue());
            ((Band)targetNode).setSpectralBandIndex(this.nameToIndexMap.get(sourceBandNameStart).intValue());
            ((Band)targetNode).setSpectralBandwidth(this.nameToBandwidthMap.get(sourceBandNameStart).floatValue());
        }
    }

    @Override
    protected List<String> getFileNames(Manifest manifest) {
        File directory = this.getInputFileParentDirectory();
        String[] fileNames = directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".nc") && (name.contains("radiance") || name.contains("flags") || name.contains("geodetic") || name.contains("BT") || name.contains("cartesian") || name.contains("indices") || name.contains("met") || name.contains("time"));
            }
        });
        return Arrays.asList(fileNames);
    }

    @Override
    protected Product findMasterProduct() {
        List<Product> productList = this.getOpenProductList();
        Product masterProduct = productList.get(0);
        for (int i = 1; i < productList.size(); ++i) {
            Product product = productList.get(i);
            if (product.getSceneRasterWidth() <= masterProduct.getSceneRasterWidth() || product.getSceneRasterHeight() <= masterProduct.getSceneRasterHeight() || product.getName().contains("flags")) continue;
            masterProduct = product;
        }
        return masterProduct;
    }

    @Override
    protected RasterDataNode addSpecialNode(Product masterProduct, Band sourceBand, Product targetProduct) {
        String sourceBandName = sourceBand.getName();
        int sourceBandNameLength = sourceBandName.length();
        String gridIndex = sourceBandName;
        if (sourceBandNameLength > 1) {
            gridIndex = sourceBandName.substring(sourceBandNameLength - 2);
        }
        Integer sourceStartOffset = this.getStartOffset(gridIndex);
        Integer sourceTrackOffset = this.getTrackOffset(gridIndex);
        if (sourceStartOffset != null && sourceTrackOffset != null) {
            short[] sourceResolutions = this.getResolutions(gridIndex);
            if (gridIndex.startsWith("t")) {
                return this.copyTiePointGrid(sourceBand, targetProduct, sourceStartOffset.intValue(), sourceTrackOffset.intValue(), sourceResolutions);
            }
            Band targetBand = new Band(sourceBandName, sourceBand.getDataType(), sourceBand.getRasterWidth(), sourceBand.getRasterHeight());
            targetProduct.addBand(targetBand);
            ProductUtils.copyRasterDataNodeProperties((RasterDataNode)sourceBand, (RasterDataNode)targetBand);
            RenderedImage sourceRenderedImage = sourceBand.getSourceImage().getImage(0);
            AffineTransform imageToModelTransform = new AffineTransform();
            float[] offsets = this.getOffsets(sourceStartOffset.intValue(), sourceTrackOffset.intValue(), sourceResolutions);
            imageToModelTransform.translate(offsets[0], offsets[1]);
            short[] referenceResolutions = this.getReferenceResolutions();
            int subSamplingX = sourceResolutions[0] / referenceResolutions[0];
            int subSamplingY = sourceResolutions[1] / referenceResolutions[1];
            imageToModelTransform.scale(subSamplingX, subSamplingY);
            DefaultMultiLevelModel targetModel = new DefaultMultiLevelModel(imageToModelTransform, sourceRenderedImage.getWidth(), sourceRenderedImage.getHeight());
            DefaultMultiLevelSource targetMultiLevelSource = new DefaultMultiLevelSource(sourceRenderedImage, (MultiLevelModel)targetModel);
            targetBand.setSourceImage((MultiLevelImage)new DefaultMultiLevelImage((MultiLevelSource)targetMultiLevelSource));
            return targetBand;
        }
        return sourceBand;
    }

    @Override
    protected void setAutoGrouping(Product[] sourceProducts, Product targetProduct) {
        String[] unwantedGroups;
        String bandGrouping = this.getAutoGroupingString(sourceProducts);
        for (String unwantedGroup : unwantedGroups = new String[]{"F1_BT", "F2_BT", "S1_radiance", "S2_radiance", "S3_radiance", "S4_radiance", "S5_radiance", "S6_radiance", "S7_BT", "S8_BT", "S9_BT"}) {
            if (bandGrouping.startsWith(unwantedGroup)) {
                bandGrouping = bandGrouping.replace(unwantedGroup + ":", "");
                continue;
            }
            if (!bandGrouping.contains(unwantedGroup)) continue;
            bandGrouping = bandGrouping.replace(":" + unwantedGroup, "");
        }
        targetProduct.setAutoGrouping("F*BT_in*:F*BT_io*:radiance_an:radiance_ao:radiance_bn:radiance_bo:radiance_cn:radiance_co:S*BT_in*:S*BT_io*:" + bandGrouping);
    }

    @Override
    protected void setSceneTransforms(Product product) {
    }

    @Override
    protected void setBandGeoCodings(Product product) {
        if (Config.instance((String)"s3tbx").load().preferences().getBoolean(SLSTR_L1B_USE_PIXELGEOCODINGS, false)) {
            this.setPixelBandGeoCodings(product);
        } else {
            this.setTiePointBandGeoCodings(product);
        }
    }

    private void setTiePointBandGeoCodings(Product product) {
        Band[] bands;
        for (Band band : bands = product.getBands()) {
            this.setTiePointBandGeoCoding(product, band, band.getName().substring(band.getName().length() - 2));
        }
        ProductNodeGroup maskGroup = product.getMaskGroup();
        for (int i = 0; i < maskGroup.getNodeCount(); ++i) {
            Mask mask = (Mask)maskGroup.get(i);
            this.setTiePointBandGeoCoding(product, (Band)mask, this.getGridIndexFromMask(mask));
        }
    }

    private void setTiePointBandGeoCoding(Product product, Band band, String gridIndex) {
        if (this.geoCodingMap.containsKey(gridIndex)) {
            band.setGeoCoding(this.geoCodingMap.get(gridIndex));
        } else {
            TiePointGrid origLatGrid = product.getTiePointGrid("latitude_tx");
            TiePointGrid origLonGrid = product.getTiePointGrid("longitude_tx");
            if (origLatGrid == null || origLonGrid == null) {
                return;
            }
            short[] referenceResolutions = this.getReferenceResolutions();
            short[] sourceResolutions = this.getResolutions(gridIndex);
            Integer sourceStartOffset = this.getStartOffset(gridIndex);
            Integer sourceTrackOffset = this.getTrackOffset(gridIndex);
            if (sourceStartOffset != null && sourceTrackOffset != null) {
                float[] offsets = this.getOffsets(sourceStartOffset.intValue(), sourceTrackOffset.intValue(), sourceResolutions);
                float[] scalings = new float[]{(float)sourceResolutions[0] / (float)referenceResolutions[0], (float)sourceResolutions[1] / (float)referenceResolutions[1]};
                AffineTransform transform = new AffineTransform();
                transform.translate(offsets[0], offsets[1]);
                transform.scale(scalings[0], scalings[1]);
                try {
                    SlstrTiePointGeoCoding geoCoding = new SlstrTiePointGeoCoding(origLatGrid, origLonGrid, new AffineTransform2D(transform));
                    band.setGeoCoding((GeoCoding)geoCoding);
                    this.geoCodingMap.put(gridIndex, (GeoCoding)geoCoding);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
        }
    }

    private void setPixelBandGeoCodings(Product product) {
        Band[] bands;
        for (Band band : bands = product.getBands()) {
            GeoCoding bandGeoCoding = this.getBandGeoCoding(product, band.getName().substring(band.getName().length() - 2));
            band.setGeoCoding(bandGeoCoding);
        }
        ProductNodeGroup maskGroup = product.getMaskGroup();
        for (int i = 0; i < maskGroup.getNodeCount(); ++i) {
            Mask mask = (Mask)maskGroup.get(i);
            GeoCoding bandGeoCoding = this.getBandGeoCoding(product, mask.getName().substring(mask.getName().length() - 2));
            mask.setGeoCoding(bandGeoCoding);
        }
    }

    private GeoCoding getBandGeoCoding(Product product, String end) {
        if (this.geoCodingMap.containsKey(end)) {
            return this.geoCodingMap.get(end);
        }
        Band latBand = null;
        Band lonBand = null;
        switch (end) {
            case "an": {
                latBand = product.getBand("latitude_an");
                lonBand = product.getBand("longitude_an");
                break;
            }
            case "ao": {
                latBand = product.getBand("latitude_ao");
                lonBand = product.getBand("longitude_ao");
                break;
            }
            case "bn": {
                latBand = product.getBand("latitude_bn");
                lonBand = product.getBand("longitude_bn");
                break;
            }
            case "bo": {
                latBand = product.getBand("latitude_bo");
                lonBand = product.getBand("longitude_bo");
                break;
            }
            case "cn": {
                latBand = product.getBand("latitude_cn");
                lonBand = product.getBand("longitude_cn");
                break;
            }
            case "co": {
                latBand = product.getBand("latitude_co");
                lonBand = product.getBand("longitude_co");
                break;
            }
            case "in": {
                latBand = product.getBand("latitude_in");
                lonBand = product.getBand("longitude_in");
                break;
            }
            case "io": {
                latBand = product.getBand("latitude_io");
                lonBand = product.getBand("longitude_io");
            }
        }
        if (latBand != null && lonBand != null) {
            BasicPixelGeoCoding geoCoding = GeoCodingFactory.createPixelGeoCoding((Band)latBand, (Band)lonBand, (String)"", (int)5);
            this.geoCodingMap.put(end, (GeoCoding)geoCoding);
            return geoCoding;
        }
        return null;
    }

    private String getGridIndexFromMask(Mask mask) {
        String maskName = mask.getName();
        if (maskName.contains("_an_")) {
            return "an";
        }
        if (maskName.contains("_ao_")) {
            return "ao";
        }
        if (maskName.contains("_bn_")) {
            return "bn";
        }
        if (maskName.contains("_bo_")) {
            return "bo";
        }
        if (maskName.contains("_cn_")) {
            return "cn";
        }
        if (maskName.contains("_co_")) {
            return "co";
        }
        if (maskName.contains("_in_")) {
            return "in";
        }
        if (maskName.contains("_io_")) {
            return "io";
        }
        return "";
    }
}

