/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.slstr;

import org.esa.s3tbx.dataio.s3.Sentinel3ProductReader;
import org.esa.s3tbx.dataio.s3.slstr.SlstrProductFactory;
import org.esa.snap.core.datamodel.MetadataElement;

public abstract class SlstrL2ProductFactory
extends SlstrProductFactory {
    private int nadirStartOffset;
    private int nadirTrackOffset;
    private int obliqueStartOffset;
    private int obliqueTrackOffset;

    protected SlstrL2ProductFactory(Sentinel3ProductReader productReader) {
        super(productReader);
    }

    @Override
    protected void processProductSpecificMetadata(MetadataElement metadataElement) {
        MetadataElement slstrInformationElement = metadataElement.getElement("slstrProductInformation");
        for (int i = 0; i < slstrInformationElement.getNumElements(); ++i) {
            MetadataElement slstrElement = slstrInformationElement.getElementAt(i);
            String slstrElementName = slstrElement.getName();
            if (!slstrElementName.endsWith("ImageSize")) continue;
            int startOffset = Integer.parseInt(slstrElement.getAttribute("startOffset").getData().getElemString());
            int trackOffset = Integer.parseInt(slstrElement.getAttribute("trackOffset").getData().getElemString());
            if (slstrElementName.equals("nadirImageSize")) {
                this.nadirStartOffset = startOffset;
                this.nadirTrackOffset = trackOffset;
                this.setReferenceStartOffset(startOffset);
                this.setReferenceTrackOffset(trackOffset);
                this.setReferenceResolutions(this.getResolutions("n"));
                continue;
            }
            this.obliqueStartOffset = startOffset;
            this.obliqueTrackOffset = trackOffset;
        }
    }

    @Override
    protected Integer getStartOffset(String gridIndex) {
        if (gridIndex.endsWith("o")) {
            return this.obliqueStartOffset;
        }
        return this.nadirStartOffset;
    }

    @Override
    protected Integer getTrackOffset(String gridIndex) {
        if (gridIndex.endsWith("o")) {
            return this.obliqueTrackOffset;
        }
        return this.nadirTrackOffset;
    }
}

