/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.slstr;

import java.awt.geom.Point2D;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.SceneTransformProvider;
import org.esa.snap.core.transform.AbstractTransform2D;
import org.esa.snap.core.transform.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public class SlstrGeoCodingSceneTransformProvider
implements SceneTransformProvider {
    private final GeoCoding sceneGeoCoding;
    private final GeoCoding modelGeoCoding;
    private final ModelToSceneTransform modelToSceneTransform;
    private final SceneToModelTransform sceneToModelTransform;

    public SlstrGeoCodingSceneTransformProvider(GeoCoding sceneGeoCoding, GeoCoding modelGeoCoding) {
        this.sceneGeoCoding = sceneGeoCoding;
        this.modelGeoCoding = modelGeoCoding;
        this.modelToSceneTransform = new ModelToSceneTransform();
        this.sceneToModelTransform = new SceneToModelTransform();
    }

    public MathTransform2D getModelToSceneTransform() {
        return this.modelToSceneTransform;
    }

    public MathTransform2D getSceneToModelTransform() {
        return this.sceneToModelTransform;
    }

    private class SceneToModelTransform
    extends SlstrSceneTransform {
        private SceneToModelTransform() {
        }

        public Point2D transform(Point2D ptSrc, Point2D ptDst) throws TransformException {
            return this.transform(ptSrc, ptDst, SlstrGeoCodingSceneTransformProvider.this.sceneGeoCoding, SlstrGeoCodingSceneTransformProvider.this.modelGeoCoding);
        }

        public MathTransform2D inverse() throws NoninvertibleTransformException {
            return SlstrGeoCodingSceneTransformProvider.this.modelToSceneTransform;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof SceneToModelTransform)) {
                return false;
            }
            SceneToModelTransform that = (SceneToModelTransform)((Object)object);
            return that.getModelGeoCoding().equals(this.getModelGeoCoding()) && that.getSceneGeoCoding().equals(this.getSceneGeoCoding());
        }

        public int hashCode() {
            return SlstrGeoCodingSceneTransformProvider.this.modelGeoCoding.hashCode() + SlstrGeoCodingSceneTransformProvider.this.sceneGeoCoding.hashCode() + 2;
        }
    }

    private class ModelToSceneTransform
    extends SlstrSceneTransform {
        private ModelToSceneTransform() {
        }

        public Point2D transform(Point2D ptSrc, Point2D ptDst) throws TransformException {
            return this.transform(ptSrc, ptDst, SlstrGeoCodingSceneTransformProvider.this.modelGeoCoding, SlstrGeoCodingSceneTransformProvider.this.sceneGeoCoding);
        }

        public MathTransform2D inverse() throws NoninvertibleTransformException {
            return SlstrGeoCodingSceneTransformProvider.this.sceneToModelTransform;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ModelToSceneTransform)) {
                return false;
            }
            ModelToSceneTransform that = (ModelToSceneTransform)((Object)object);
            return that.getModelGeoCoding().equals(this.getModelGeoCoding()) && that.getSceneGeoCoding().equals(this.getSceneGeoCoding());
        }

        public int hashCode() {
            return SlstrGeoCodingSceneTransformProvider.this.modelGeoCoding.hashCode() + SlstrGeoCodingSceneTransformProvider.this.sceneGeoCoding.hashCode() + 1;
        }
    }

    private abstract class SlstrSceneTransform
    extends AbstractTransform2D {
        private SlstrSceneTransform() {
        }

        protected Point2D transform(Point2D ptSrc, Point2D ptDst, GeoCoding from, GeoCoding to) throws TransformException {
            if (!from.canGetGeoPos() || !to.canGetPixelPos()) {
                throw new TransformException("Cannot transform");
            }
            PixelPos pixelPos = new PixelPos(ptSrc.getX(), ptSrc.getY());
            GeoPos geoPos = from.getGeoPos(pixelPos, new GeoPos());
            pixelPos = to.getPixelPos(geoPos, pixelPos);
            if (Double.isNaN(geoPos.getLat()) || Double.isNaN(geoPos.getLon()) || Double.isNaN(pixelPos.getX()) || Double.isNaN(pixelPos.getY())) {
                throw new TransformException("Cannot transform");
            }
            ptDst.setLocation(pixelPos.getX(), pixelPos.getY());
            return ptDst;
        }

        GeoCoding getModelGeoCoding() {
            return SlstrGeoCodingSceneTransformProvider.this.modelGeoCoding;
        }

        GeoCoding getSceneGeoCoding() {
            return SlstrGeoCodingSceneTransformProvider.this.sceneGeoCoding;
        }
    }
}

