/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.meris;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.s3tbx.dataio.s3.AbstractProductFactory;
import org.esa.s3tbx.dataio.s3.Manifest;
import org.esa.s3tbx.dataio.s3.Sentinel3ProductReader;
import org.esa.s3tbx.dataio.s3.util.S3NetcdfReader;
import org.esa.s3tbx.dataio.s3.util.S3NetcdfReaderFactory;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoCodingFactory;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.runtime.Config;

public class MerisProductFactory
extends AbstractProductFactory {
    private Map<String, Float> nameToWavelengthMap = new HashMap<String, Float>();
    private Map<String, Float> nameToBandwidthMap = new HashMap<String, Float>();
    private Map<String, Integer> nameToIndexMap = new HashMap<String, Integer>();
    private int subSamplingX;
    private int subSamplingY;
    private int rows = -1;
    private int columns = -1;
    public static final String MERIS_SAFE_USE_PIXELGEOCODING = "s3tbx.reader.meris.pixelGeoCoding";

    public MerisProductFactory(Sentinel3ProductReader productReader) {
        super(productReader);
    }

    @Override
    protected List<String> getFileNames(Manifest manifest) {
        List<String> fileNames = manifest.getFileNames(new String[0]);
        MetadataElement metadataElement = manifest.getMetadata().getElement("metadataSection");
        MetadataElement merisInformationElement = metadataElement.getElement("merisProductInformation");
        MetadataElement imageSizeElement = merisInformationElement.getElement("imageSize");
        this.rows = Integer.parseInt(imageSizeElement.getAttribute("rows").getData().toString());
        this.columns = Integer.parseInt(imageSizeElement.getAttribute("columns").getData().toString());
        return fileNames;
    }

    @Override
    protected void processProductSpecificMetadata(MetadataElement metadataElement) {
        MetadataElement merisInformationElement = metadataElement.getElement("merisProductInformation");
        MetadataElement samplingParametersElement = merisInformationElement.getElement("samplingParameters");
        this.subSamplingY = Integer.parseInt(samplingParametersElement.getAttribute("rowsPerTiePoint").getData().toString());
        this.subSamplingX = Integer.parseInt(samplingParametersElement.getAttribute("columnsPerTiePoint").getData().toString());
        MetadataElement bandDescriptionsElement = merisInformationElement.getElement("bandDescriptions");
        if (bandDescriptionsElement != null) {
            for (int i = 0; i < bandDescriptionsElement.getNumElements(); ++i) {
                MetadataElement bandDescriptionElement = bandDescriptionsElement.getElementAt(i);
                String bandName = bandDescriptionElement.getAttribute("name").getData().getElemString();
                float wavelength = Float.parseFloat(bandDescriptionElement.getAttribute("centralWavelength").getData().getElemString());
                float bandWidth = Float.parseFloat(bandDescriptionElement.getAttribute("bandWidth").getData().getElemString());
                this.nameToWavelengthMap.put(bandName, Float.valueOf(wavelength));
                this.nameToBandwidthMap.put(bandName, Float.valueOf(bandWidth));
                this.nameToIndexMap.put(bandName, i);
            }
        }
    }

    @Override
    protected Product findMasterProduct() {
        List<Product> productList = this.getOpenProductList();
        Product masterProduct = null;
        if (this.rows > 0 && this.columns > 0) {
            for (Product product : productList) {
                if (product.getSceneRasterWidth() != this.columns || product.getSceneRasterHeight() != this.rows) continue;
                masterProduct = product;
            }
        }
        if (masterProduct == null) {
            int masterproductWidth = -1;
            int masterproductHeight = -1;
            for (Product product : productList) {
                if (product.getSceneRasterWidth() <= masterproductWidth || product.getSceneRasterHeight() <= masterproductHeight || product.getName().contains("flags") || product.getName().contains("time") || product.getName().contains("tie")) continue;
                masterProduct = product;
                masterproductWidth = product.getSceneRasterWidth();
                masterproductHeight = product.getSceneRasterHeight();
            }
        }
        return masterProduct;
    }

    @Override
    protected RasterDataNode addSpecialNode(Product masterProduct, Band sourceBand, Product targetProduct) {
        String sourceBandName = sourceBand.getName();
        if (targetProduct.containsBand(sourceBandName)) {
            sourceBand.setName("TP_" + sourceBandName);
        }
        return MerisProductFactory.copyBandAsTiePointGrid(sourceBand, targetProduct, this.subSamplingX, this.subSamplingY, 0.0f, 0.0f);
    }

    @Override
    protected void setGeoCoding(Product targetProduct) throws IOException {
        if (Config.instance((String)"s3tbx").load().preferences().getBoolean(MERIS_SAFE_USE_PIXELGEOCODING, false)) {
            Band latBand = targetProduct.getBand("latitude");
            Band lonBand = targetProduct.getBand("longitude");
            if (latBand != null && lonBand != null) {
                targetProduct.setSceneGeoCoding((GeoCoding)GeoCodingFactory.createPixelGeoCoding((Band)latBand, (Band)lonBand, (String)this.getValidExpression(), (int)5));
            }
        }
        if (targetProduct.getSceneGeoCoding() == null && targetProduct.getTiePointGrid("latitude") != null && targetProduct.getTiePointGrid("longitude") != null) {
            targetProduct.setSceneGeoCoding((GeoCoding)new TiePointGeoCoding(targetProduct.getTiePointGrid("latitude"), targetProduct.getTiePointGrid("longitude")));
        }
        if (targetProduct.getSceneGeoCoding() == null && targetProduct.getTiePointGrid("TP_latitude") != null && targetProduct.getTiePointGrid("TP_longitude") != null) {
            targetProduct.setSceneGeoCoding((GeoCoding)new TiePointGeoCoding(targetProduct.getTiePointGrid("TP_latitude"), targetProduct.getTiePointGrid("TP_longitude")));
        }
    }

    @Override
    protected Product readProduct(String fileName) throws IOException {
        File file = new File(this.getInputFileParentDirectory(), fileName);
        if (!file.exists()) {
            return null;
        }
        S3NetcdfReader reader = S3NetcdfReaderFactory.createS3NetcdfReader(file);
        this.addSeparatingDimensions(reader.getSuffixesForSeparatingDimensions());
        return reader.readProduct();
    }

    protected String getValidExpression() {
        return "";
    }

    protected float getWavelength(String name) {
        return this.nameToWavelengthMap.get(name).floatValue();
    }

    protected float getBandwidth(String name) {
        return this.nameToBandwidthMap.get(name).floatValue();
    }

    protected int getBandindex(String name) {
        return this.nameToIndexMap.get(name);
    }
}

