/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.meris;

import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.esa.s3tbx.dataio.s3.Sentinel3ProductReader;
import org.esa.s3tbx.dataio.s3.meris.MerisProductFactory;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;

public class MerisLevel2ProductFactory
extends MerisProductFactory {
    public MerisLevel2ProductFactory(Sentinel3ProductReader productReader) {
        super(productReader);
    }

    @Override
    protected Band addBand(Band sourceBand, Product targetProduct) {
        String sourceBandName = sourceBand.getName();
        if (sourceBandName.startsWith("IWV")) {
            if (sourceBand.getProduct().getName().startsWith("l")) {
                sourceBand.setName("L_" + sourceBandName);
            } else {
                sourceBand.setName("W_" + sourceBandName);
            }
        }
        return super.addBand(sourceBand, targetProduct);
    }

    @Override
    protected void configureTargetNode(Band sourceBand, RasterDataNode targetNode) {
        Band targetBand;
        if (targetNode.getName().matches("M[0-1][0-9].*") && targetNode instanceof Band) {
            targetBand = (Band)targetNode;
            String partialName = targetBand.getName().substring(0, 3);
            targetBand.setSpectralBandIndex(this.getBandindex(partialName));
            targetBand.setSpectralWavelength(this.getWavelength(partialName));
            targetBand.setSpectralBandwidth(this.getBandwidth(partialName));
        }
        if ((targetNode.getName().startsWith("ADG443_NN") || targetNode.getName().startsWith("CHL_NN") || targetNode.getName().startsWith("CHL_OC4ME") || targetNode.getName().startsWith("KD490_M07")) && targetNode instanceof Band) {
            targetBand = (Band)targetNode;
            String unit = targetBand.getUnit();
            Pattern pattern = Pattern.compile("lg\\s*\\(\\s*re:?\\s*(.*)\\)");
            Matcher m = pattern.matcher(unit);
            if (m.matches()) {
                targetBand.setLog10Scaled(true);
                targetBand.setUnit(m.group(1));
                String description = targetBand.getDescription();
                description = description.replace("log10 scaled ", "");
                targetBand.setDescription(description);
            } else {
                this.getLogger().log(Level.WARNING, "Unit extraction not working for band " + targetNode.getName());
            }
        }
        targetNode.setValidPixelExpression(this.getValidExpression());
    }

    @Override
    protected void setAutoGrouping(Product[] sourceProducts, Product targetProduct) {
        targetProduct.setAutoGrouping("M*_rho_toa:M*_rho_top:M*_rho_w:atmospheric_temperature_profile:lambda0:FWHM:solar_flux");
    }
}

