/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3.meris;

import org.esa.s3tbx.dataio.s3.Sentinel3ProductReader;
import org.esa.s3tbx.dataio.s3.meris.MerisProductFactory;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;

public class MerisLevel1ProductFactory
extends MerisProductFactory {
    private static final String validExpression = "!quality_flags.invalid";

    public MerisLevel1ProductFactory(Sentinel3ProductReader productReader) {
        super(productReader);
    }

    @Override
    protected void configureTargetNode(Band sourceBand, RasterDataNode targetNode) {
        if (targetNode.getName().matches("M[0-1][0-9].*") && targetNode instanceof Band) {
            Band targetBand = (Band)targetNode;
            String partialName = targetBand.getName().substring(0, 3);
            targetBand.setSpectralBandIndex(this.getBandindex(partialName));
            targetBand.setSpectralWavelength(this.getWavelength(partialName));
            targetBand.setSpectralBandwidth(this.getBandwidth(partialName));
        }
        targetNode.setValidPixelExpression(this.getValidExpression());
    }

    @Override
    protected void setAutoGrouping(Product[] sourceProducts, Product targetProduct) {
        targetProduct.setAutoGrouping("M*_radiance:atmospheric_temperature_profile:lambda0:FWHM:solar_flux");
    }

    @Override
    protected String getValidExpression() {
        return validExpression;
    }
}

