/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3;

import java.io.File;
import java.util.Locale;
import java.util.regex.Pattern;
import org.esa.s3tbx.dataio.s3.Sentinel3ProductReader;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.util.io.SnapFileFilter;

public class Sentinel3ProductReaderPlugIn
implements ProductReaderPlugIn {
    private static final Class[] SUPPORTED_INPUT_TYPES = new Class[]{String.class, File.class};
    private static final String FORMAT_NAME = "Sen3";
    private final String formatName;
    private final String manifestFileBasename;
    private final String alternativeManifestFileBasename;
    private final String[] fileExtensions;
    private final Pattern directoryNamePattern;
    private final String description;
    private final String[] formatNames;

    public Sentinel3ProductReaderPlugIn() {
        this(FORMAT_NAME, "Sentinel-3 products", "S3.?_(OL_1_E[FR]R|OL_2_(L[FR]R|W[FR]R)|SL_1_RBT|SL_2_(LST|WCT|WST)|SY_1_SYN|SY_2_(VGP|SYN)|SY_[23]_VG1)_.*(.SEN3)?", "xfdumanifest", "L1c_Manifest", ".xml");
    }

    protected Sentinel3ProductReaderPlugIn(String formatName, String description, String directoryNamePattern, String manifestFileBasename, String alternativeManifestFileBasename, String ... fileExtensions) {
        this.formatName = formatName;
        this.fileExtensions = fileExtensions;
        this.directoryNamePattern = Pattern.compile(directoryNamePattern);
        this.description = description;
        this.formatNames = new String[]{formatName};
        this.manifestFileBasename = manifestFileBasename;
        this.alternativeManifestFileBasename = alternativeManifestFileBasename;
    }

    public final DecodeQualification getDecodeQualification(Object input) {
        if (this.isInputValid(input)) {
            return DecodeQualification.INTENDED;
        }
        return DecodeQualification.UNABLE;
    }

    public final Class[] getInputTypes() {
        return SUPPORTED_INPUT_TYPES;
    }

    public ProductReader createReaderInstance() {
        return new Sentinel3ProductReader(this);
    }

    public final String[] getFormatNames() {
        return this.formatNames;
    }

    public final String[] getDefaultFileExtensions() {
        return this.fileExtensions;
    }

    public final String getDescription(Locale locale) {
        return this.description;
    }

    public final SnapFileFilter getProductFileFilter() {
        return new SnapFileFilter(this.formatName, this.fileExtensions, this.description);
    }

    private boolean isValidInputFileName(String name) {
        for (String fileExtension : this.fileExtensions) {
            String manifestFileName = this.manifestFileBasename + fileExtension;
            String alternativeManifestFileName = this.alternativeManifestFileBasename + fileExtension;
            if (!manifestFileName.equalsIgnoreCase(name) && !alternativeManifestFileName.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private boolean isInputValid(Object input) {
        File inputFile = new File(input.toString());
        File parentFile = inputFile.getParentFile();
        return parentFile != null && this.isValidDirectoryName(parentFile.getName()) && this.isValidInputFileName(inputFile.getName()) || this.isValidDirectoryName(inputFile.getName()) && new File(inputFile, "xfdumanifest.xml").exists() || this.isValidDirectoryName(inputFile.getName()) && new File(inputFile, "L1c_Manifest.xml").exists();
    }

    private boolean isValidDirectoryName(String name) {
        return this.directoryNamePattern.matcher(name).matches();
    }
}

