/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3;

import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.GenericMultiLevelSource;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import javax.media.jai.ImageLayout;
import org.esa.s3tbx.dataio.s3.LonLatFunction;
import org.esa.s3tbx.dataio.s3.LonLatFunctionOpImage;
import org.esa.snap.core.util.jai.SingleBandedSampleModel;

public final class LonLatMultiLevelSource
extends GenericMultiLevelSource {
    private final LonLatFunction function;
    private final int targetDataType;

    public static MultiLevelSource create(MultiLevelSource lonSource, MultiLevelSource latSource, LonLatFunction function, int targetDataType) {
        return new LonLatMultiLevelSource(lonSource, latSource, function, targetDataType);
    }

    private LonLatMultiLevelSource(MultiLevelSource lonSource, MultiLevelSource latSource, LonLatFunction function, int targetDataType) {
        super(new MultiLevelSource[]{lonSource, latSource});
        this.function = function;
        this.targetDataType = targetDataType;
    }

    protected RenderedImage createImage(RenderedImage[] sourceImages, int level) {
        RenderedImage lonImage = sourceImages[0];
        RenderedImage latImage = sourceImages[1];
        SingleBandedSampleModel sampleModel = new SingleBandedSampleModel(this.targetDataType, lonImage.getSampleModel().getWidth(), lonImage.getSampleModel().getHeight());
        ImageLayout imageLayout = new ImageLayout(lonImage);
        imageLayout.setSampleModel((SampleModel)sampleModel);
        return new LonLatFunctionOpImage(lonImage, latImage, imageLayout, this.function);
    }
}

